/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.plan.local.service.internal;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.UuidOpEntity;
import com.biz.crm.kms.business.invoice.sales.data.sdk.dto.SalesDataDto;
import com.biz.crm.kms.business.invoice.sales.data.sdk.service.InvoiceSalesDataVoService;
import com.biz.crm.kms.business.invoice.sales.data.sdk.vo.SalesDataVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.tpm.business.activity.plan.local.entity.MarketingFeeUseProgress;
import com.biz.crm.tpm.business.activity.plan.local.mapper.MarketingFeeUseProgressMapper;
import com.biz.crm.tpm.business.activity.plan.local.repository.MarketingFeeUseProgressMiddleRepository;
import com.biz.crm.tpm.business.activity.plan.local.repository.MarketingFeeUseProgressRepository;
import com.biz.crm.tpm.business.activity.plan.local.service.MarketingFeeUseProgressService;
import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesGoalDto;
import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesPerformanceDto;
import com.biz.crm.tpm.business.sales.goal.sdk.service.SalesGoalService;
import com.biz.crm.tpm.business.sales.goal.sdk.service.SalesPerformanceVoService;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesGoalVo;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesPerformanceVo;
import com.biz.crm.tpm.business.year.budget.sdk.dto.YearBudgetDto;
import com.biz.crm.tpm.business.year.budget.sdk.service.YearBudgetSdkService;
import com.biz.crm.tpm.business.year.budget.sdk.vo.YearBudgetVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.math.BigDecimal;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MarketingFeeUseProgressServiceImpl
implements MarketingFeeUseProgressService {
    private static final Logger log = LoggerFactory.getLogger(MarketingFeeUseProgressServiceImpl.class);
    @Autowired(required=false)
    private MarketingFeeUseProgressRepository marketingFeeUseProgressRepository;
    @Autowired(required=false)
    private MarketingFeeUseProgressMiddleRepository marketingFeeUseProgressMiddleRepository;
    @Autowired(required=false)
    private SalesGoalService salesGoalService;
    @Autowired(required=false)
    private SalesPerformanceVoService salesPerformanceVoService;
    @Autowired(required=false)
    private DictToolkitService dictToolkitService;
    @Autowired(required=false)
    private InvoiceSalesDataVoService invoiceSalesDataVoService;
    @Autowired(required=false)
    private YearBudgetSdkService yearBudgetSdkService;

    @Override
    public void frJob(List<String> yearMonths) {
        ((LambdaUpdateChainWrapper)this.marketingFeeUseProgressRepository.lambdaUpdate().in(MarketingFeeUseProgress::getYearMonthStr, yearMonths)).remove();
        this.marketingFeeUseProgressMiddleRepository.lambdaUpdate().remove();
        this.marketingFeeUseProgressMiddleRepository.frJob(yearMonths);
        this.marketingFeeUseProgressRepository.insertTable();
        Map region = this.dictToolkitService.findMapByDictTypeCode("MDM_CUSTOMIZE_ORG");
        int current = 1;
        int pageSize = 300;
        int count = 1;
        Page result = null;
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(MarketingFeeUseProgress::getYearMonthStr, yearMonths)).orderByDesc(UuidOpEntity::getCreateTime);
        do {
            try {
                Page page = new Page((long)current, (long)pageSize);
                result = (Page)((MarketingFeeUseProgressMapper)this.marketingFeeUseProgressRepository.getBaseMapper()).selectPage((IPage)page, (Wrapper)wrapper);
                if (result == null || CollectionUtils.isEmpty((Collection)result.getRecords())) break;
                log.info("\u8425\u9500\u8d39\u7528\u4f7f\u7528\u8fdb\u5ea6-\u8dd1\u5e06\u8f6f-\u9875\u7801{} \u67e5\u8be2\u7684marketingFeeUseProgress\u5206\u9875\u6570\u636e\uff1a{}", (Object)(++current - 1), (Object)JSON.toJSONString((Object)result));
                HashMap salesGoalVoMap = new HashMap();
                List salesGoalDtos = result.getRecords().stream().map(e -> new SalesGoalDto((MarketingFeeUseProgress)((Object)e)){
                    final /* synthetic */ MarketingFeeUseProgress val$e;
                    {
                        this.val$e = marketingFeeUseProgress;
                        this.setYearMonthLy(this.val$e.getYearMonthStr());
                        this.setRegionCode(this.val$e.getRegion());
                        this.setSystemCode(this.val$e.getSystemCode());
                    }
                }).collect(Collectors.toList());
                List salesGoalVos = this.salesGoalService.findListForFR(salesGoalDtos);
                if (!CollectionUtils.isEmpty((Collection)salesGoalVos)) {
                    salesGoalVoMap.putAll(salesGoalVos.stream().collect(Collectors.toMap(e -> StringUtils.join((Object[])new String[]{e.getYearMonthLy(), e.getRegionCode(), e.getSystemCode()}), Function.identity())));
                }
                log.info("\u8425\u9500\u8d39\u7528\u4f7f\u7528\u8fdb\u5ea6-\u8dd1\u5e06\u8f6f-\u9875\u7801{} \u67e5\u8be2\u7684SalesGoalVo\uff1a{}", (Object)(current - 1), (Object)JSON.toJSONString(salesGoalVoMap));
                HashMap salesPerformanceVoMap = new HashMap();
                List salesPerformanceDtos = result.getRecords().stream().map(e -> new SalesPerformanceDto((MarketingFeeUseProgress)((Object)e), region){
                    final /* synthetic */ MarketingFeeUseProgress val$e;
                    final /* synthetic */ Map val$region;
                    {
                        this.val$e = marketingFeeUseProgress;
                        this.val$region = map;
                        this.setSalesMonth(this.val$e.getYearMonthStr().replace("-", ""));
                        this.setRegion(this.val$region.getOrDefault(this.val$e.getRegion(), "not found"));
                        this.setRetailer(this.val$e.getSystemName());
                    }
                }).collect(Collectors.toList());
                List salesPerformanceVos = this.salesPerformanceVoService.findListForFR(salesPerformanceDtos);
                if (!CollectionUtils.isEmpty((Collection)salesPerformanceVos)) {
                    salesPerformanceVoMap.putAll(salesPerformanceVos.stream().collect(Collectors.toMap(e -> StringUtils.join((Object[])new String[]{e.getSalesMonth(), e.getRegion(), e.getRetailer()}), Function.identity())));
                }
                log.info("\u8425\u9500\u8d39\u7528\u4f7f\u7528\u8fdb\u5ea6-\u8dd1\u5e06\u8f6f-\u9875\u7801{} \u67e5\u8be2\u7684SalesPerformance\uff1a{}", (Object)(current - 1), (Object)JSON.toJSONString(salesPerformanceVoMap));
                HashMap salesDataVoMap = new HashMap();
                List salesDataDtos = result.getRecords().stream().map(e -> new SalesDataDto((MarketingFeeUseProgress)((Object)e)){
                    final /* synthetic */ MarketingFeeUseProgress val$e;
                    {
                        this.val$e = marketingFeeUseProgress;
                        this.setYearMonth(this.val$e.getYearMonthStr());
                        this.setBusinessArea(this.val$e.getRegion());
                        this.setCustomerRetailerCode(this.val$e.getSystemCode());
                    }
                }).collect(Collectors.toList());
                List salesDataVos = this.invoiceSalesDataVoService.findListForFR(salesDataDtos);
                if (!CollectionUtils.isEmpty((Collection)salesDataVos)) {
                    salesDataVoMap.putAll(salesDataVos.stream().collect(Collectors.toMap(e -> StringUtils.join((Object[])new String[]{e.getYearMonth(), e.getBusinessArea(), e.getCustomerRetailerCode()}), Function.identity())));
                }
                log.info("\u8425\u9500\u8d39\u7528\u4f7f\u7528\u8fdb\u5ea6-\u8dd1\u5e06\u8f6f-\u9875\u7801{} \u67e5\u8be2\u7684SalesDataVo\uff1a{}", (Object)(current - 1), (Object)JSON.toJSONString(salesDataVoMap));
                result.getRecords().forEach(e -> {
                    BigDecimal pos;
                    String key = StringUtils.join((Object[])new String[]{e.getYearMonthStr(), e.getRegion(), e.getSystemCode()});
                    String key1 = StringUtils.join((Object[])new String[]{e.getYearMonthStr().replace("-", ""), region.getOrDefault(e.getRegion(), "not found"), e.getSystemName()});
                    e.setDiscountSalesAmount(BigDecimal.ZERO);
                    if (salesPerformanceVoMap.containsKey(key1)) {
                        e.setDiscountSalesAmount(((SalesPerformanceVo)salesPerformanceVoMap.get(key1)).getWarehsOutDiscountAmt());
                    }
                    e.setSalesDiscountAmount(BigDecimal.ZERO);
                    if (salesGoalVoMap.containsKey(key)) {
                        e.setSalesDiscountAmount(((SalesGoalVo)salesGoalVoMap.get(key)).getDeliveryDiscountSalesAmount());
                    }
                    e.setSalesAchievementRate(BigDecimal.ZERO);
                    if (BigDecimal.ZERO.compareTo(e.getSalesDiscountAmount()) != 0) {
                        e.setSalesAchievementRate(e.getDiscountSalesAmount().divide(e.getSalesDiscountAmount(), 4, 4));
                    }
                    BigDecimal amount = ((BigDecimal)ObjectUtils.defaultIfNull((Object)e.getHeadReserve(), (Object)BigDecimal.ZERO)).add((BigDecimal)ObjectUtils.defaultIfNull((Object)e.getExcessProfitConversion(), (Object)BigDecimal.ZERO)).add((BigDecimal)ObjectUtils.defaultIfNull((Object)e.getRegionAuthFee(), (Object)BigDecimal.ZERO));
                    e.setPosFeeRate(BigDecimal.ZERO);
                    if (salesDataVoMap.containsKey(key) && BigDecimal.ZERO.compareTo(pos = (BigDecimal)ObjectUtils.defaultIfNull((Object)((SalesDataVo)salesDataVoMap.get(key)).getSalesAmount(), (Object)BigDecimal.ZERO)) != 0) {
                        e.setPosFeeRate(amount.divide(pos, 4, 4));
                    }
                    e.setOverallMarketingFeeRate(BigDecimal.ZERO);
                    if (BigDecimal.ZERO.compareTo(e.getSalesDiscountAmount()) != 0) {
                        e.setOverallMarketingFeeRate(amount.divide(e.getSalesDiscountAmount(), 4, 4));
                    }
                    e.setTenantCode(TenantUtils.getTenantCode());
                });
                this.marketingFeeUseProgressRepository.saveOrUpdateBatch(result.getRecords());
                Set yearBudgetDtos = result.getRecords().stream().map(e -> new YearBudgetDto((MarketingFeeUseProgress)((Object)e)){
                    final /* synthetic */ MarketingFeeUseProgress val$e;
                    {
                        this.val$e = marketingFeeUseProgress;
                        this.setYearLy(this.val$e.getYearMonthStr().substring(0, 4));
                        this.setRegionCode(this.val$e.getRegion());
                        this.setSystemCode(this.val$e.getSystemCode());
                    }
                }).collect(Collectors.toSet());
                List yearBudgetVos = this.yearBudgetSdkService.findListForFR(new ArrayList(yearBudgetDtos));
                Map yearBudgetVoMap = yearBudgetVos.stream().collect(Collectors.toMap(e -> StringUtils.join((Object[])new String[]{e.getYearLy(), e.getRegionCode(), e.getSystemCode()}), Function.identity()));
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM");
                DateTimeFormatter yearFormatter = DateTimeFormatter.ofPattern("yyyy");
                result.getRecords().forEach(e -> {
                    YearMonth yearMonth = YearMonth.parse(e.getYearMonthStr(), formatter);
                    yearMonth = yearMonth.plusYears(-1L);
                    MarketingFeeUseProgress last = (MarketingFeeUseProgress)((Object)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.marketingFeeUseProgressRepository.lambdaQuery().eq(MarketingFeeUseProgress::getYearMonthStr, (Object)yearMonth.format(formatter))).eq(MarketingFeeUseProgress::getRegion, (Object)e.getRegion())).eq(MarketingFeeUseProgress::getSystemCode, (Object)e.getSystemCode())).one()));
                    e.setVsTq(BigDecimal.ZERO);
                    if (Objects.nonNull((Object)last)) {
                        e.setVsTq(e.getOverallMarketingFeeRate().subtract((BigDecimal)ObjectUtils.defaultIfNull((Object)last.getOverallMarketingFeeRate(), (Object)BigDecimal.ZERO)));
                    }
                    YearMonth currentYearMonth = YearMonth.parse(e.getYearMonthStr(), formatter);
                    String startYearMonth = currentYearMonth.format(yearFormatter) + "-01";
                    String endYearMonth = currentYearMonth.format(formatter);
                    MarketingFeeUseProgress accumulate = this.marketingFeeUseProgressRepository.accumulate(startYearMonth, endYearMonth, e.getRegion(), e.getSystemCode());
                    e.setSalesAchievementProgress(BigDecimal.ZERO);
                    if (Objects.nonNull((Object)accumulate) && BigDecimal.ZERO.compareTo(accumulate.getSalesDiscountAmount()) != 0) {
                        e.setSalesAchievementProgress(accumulate.getDiscountSalesAmount().divide(accumulate.getSalesDiscountAmount(), 4, 4));
                    }
                    e.setFeeUseProgress(BigDecimal.ZERO);
                    String budgetKey = StringUtils.join((Object[])new String[]{e.getYearMonthStr().substring(0, 4), e.getRegion(), e.getSystemCode()});
                    if (Objects.nonNull((Object)accumulate) && yearBudgetVoMap.containsKey(budgetKey) && BigDecimal.ZERO.compareTo(((YearBudgetVo)yearBudgetVoMap.get(budgetKey)).getBudgetTotalAmount()) != 0) {
                        e.setFeeUseProgress(accumulate.getRegionAuthFee().divide(((YearBudgetVo)yearBudgetVoMap.get(budgetKey)).getBudgetTotalAmount(), 4, 4));
                    }
                });
                this.marketingFeeUseProgressRepository.saveOrUpdateBatch(result.getRecords());
                ++count;
            }
            catch (Exception e2) {
                log.info("\u8425\u9500\u8d39\u7528\u4f7f\u7528\u8fdb\u5ea6-\u8dd1\u5e06\u8f6f-\u9875\u7801{} \u9519\u8bef\uff1a{}", (Object)(current - 1), (Object)e2.getMessage());
                e2.printStackTrace();
            }
        } while (count < 1000 && result.hasNext());
    }
}

