package com.biz.crm.tpm.business.activity.plan.sdk.dto;


import com.biz.crm.tpm.business.activity.plan.sdk.pojo.ActivityPlanBase;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.util.List;

/**
 * 活动方案表(ActivityPlan)
 *
 * @author wanghaojia
 * @since 2022-10-31 15:55:57
 */
@ApiModel(value = "ActivityPlanDto", description = "活动方案表Dto")
@Getter
@Setter
public class ActivityPlanDto extends ActivityPlanBase {

    @ApiModelProperty("营销策略")
    private List<ActivityPlanStrategyDto> strategyList;

    @ApiModelProperty("大区方案关联总部方案")
    private List<ActivityPlanRelatePlanDto> relatePlanList;

    @ApiModelProperty("模板配置")
    private List<ActivityPlanTemplateDto> templateList;

    @ApiModelProperty("活动方案明细")
    private List<ActivityPlanItemDto> itemList;

    @ApiModelProperty("活动方案关联细案")
    private List<ActivityPlanItemRelateDetailItemDto> relateDetailItemDtoList;
    
    @ApiModelProperty("暂存（true:暂存,false:保存）")
    private Boolean tempSave;

    @ApiModelProperty("是否已校验 Y:已校验，N:未校验")
    private String isValidate;

    @ApiModelProperty("承接业务单元")
    private String nectBusinessUnitCode;

    @ApiModelProperty(name = "区域编码(字典MDM_CUSTOMIZE_ORG)", notes = "")
    private String regionCode;

}

