package com.biz.crm.tpm.business.activity.plan.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @author wanghaojia
 * @date 2023/2/18 07:50
 */
@Data
@ApiModel("活动方案明细预算信息VO")
public class ActivityPlanItemBudgetDto {

    @ApiModelProperty("方案编码")
    private String planCode;

    @ApiModelProperty("方案编码集合")
    private List<String> planCodeList;

    @ApiModelProperty("方案名称")
    private String planName;

    @ApiModelProperty("方案明细编码")
    private String planItemCode;

    @ApiModelProperty("方案明细编码集合")
    private List<String> planItemCodeList;

    @ApiModelProperty("总部统筹预算编码")
    private String headMonthBudgetCode;

    @ApiModelProperty("总部统筹预算项目编码")
    private String headBudgetItemCode;

    @ApiModelProperty("总部统筹预算项目名称")
    private String headBudgetItemName;

    @ApiModelProperty("总部统筹预算名称")
    private String headMonthBudgetName;

    @ApiModelProperty("大区预算项目编码")
    private String monthBudgetCode;

    @ApiModelProperty("大区预算项目名称")
    private String budgetItemCode;

    @ApiModelProperty("大区预算名称")
    private String budgetItemName;

    @ApiModelProperty("是否过滤关闭状态")
    private boolean filterClose;

    @ApiModelProperty(value = "费用归口[数据字典:tpm_fee_belong]", notes = "")
    private String feeBelongCode;

}
