package com.biz.crm.tpm.business.activity.plan.sdk.dto;


import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.tpm.business.activity.plan.sdk.pojo.ActivityPlanItemBase;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 活动方案明细表(ActivityPlanItem)
 *
 * @author wanghaojia
 * @since 2022-11-01 14:39:19
 */
@ApiModel(value = "ActivityPlanItemDto", description = "活动方案明细表Dto")
@Getter
@Setter
public class ActivityPlanItemDto extends ActivityPlanItemBase {

    /**
     * 方案类型
     */
    private String planType;

    /**
     * 方案类型
     */
    private String processStatus;

    /**
     * 方案id
     */
    private String planId;
    /**
     * 活动方案明细编码
     */
    @ApiModelProperty("活动方案明细编码")
    private String planItemCode;
    /**
     * 活动方案编码
     */
    @ApiModelProperty("活动方案编码")
    private String planCode;
    /**
     * 总部预算编码
     */
    @ApiModelProperty("总部预算编码")
    private String headMonthBudgetCode;
    /**
     * 总部预算项目编码
     */
    @ApiModelProperty("总部预算项目编码")
    private String headBudgetItemCode;
    /**
     * 总部预算项目名称
     */
    @ApiModelProperty("总部预算项目名称")
    private String headBudgetItemName;
    /**
     * 大区预算编码
     */
    @ApiModelProperty("大区预算编码")
    private String monthBudgetCode;
    /**
     * 大区预算项目编码
     */
    @ApiModelProperty("大区预算项目编码")
    private String budgetItemCode;
    /**
     * 大区预算项目名称
     */
    @ApiModelProperty("大区预算项目名称")
    private String budgetItemName;

    /**
     * 活动方案编码集合
     */
    @ApiModelProperty("活动方案编码集合")
    private List<String> planCodeList;
    /**
     * 活动方案明细编码集合
     */
    @ApiModelProperty("活动方案明细编码集合")
    private List<String> planItemCodeList;

    @ApiModelProperty("门店明细")
    private List<ActivityPlanItemTerminalDto> activityPlanItemTerminalList;

    /**
     * 预算使用信息
     */
    @ApiModelProperty("预算使用信息")
    private List<ActivityPlanBudgetDto> budgetShares;

    /**
     * 是否破价
     */
    @ApiModelProperty("是否破价")
    private String isBreakPrice;


    /********************冗余********************/
    @ApiModelProperty("缓存key")
    private String cacheKey;

    @ApiModelProperty("行清理标识 Y要清理，N不清理")
    private String clearStatus;

    @ApiModelProperty("数量（整数）")
    private Integer quantityInt;
    @ApiModelProperty(name = "业态[数据字典:mdm_business_format]", notes = "业态[数据字典:mdm_business_format]")
    private String businessFormatCode;

    @ApiModelProperty("关联上级方案，是否完全承接")
    private String headMonthBudgetFullAccept;

    @ApiModelProperty("关联策略，是否完全承接")
    private String monthBudgetFullAccept;

    @ApiModelProperty("关联上级方案模板编码")
    private String relateTemplateConfigCode;

    @ApiModelProperty("是否完全结案")
    private String wholeAudit;

    /**
     * 已结案金额
     */
    @ApiModelProperty("已结案金额")
    private BigDecimal alreadyAuditAmount;
    /**
     * 审批状态
     */
    private List<String> processStatusList;

    /**
     * 行索引
     */
    @ApiModelProperty("行索引")
    private Integer indexNo;

    /**
     * 垂直大区方案兑付明细编码
     */
    @ApiModelProperty("垂直大区方案兑付明细编码")
    private String schemeForecastDetailCode;

    /**
     * 区域细分编码
     */
    @ApiModelProperty("区域细分编码")
    private String activityOrgSubdivisionCode;
    @ApiModelProperty("beginTime")
    private String activityBeginDateBeginTime;

    @ApiModelProperty("endTime")
    private String activityBeginDateEndTime;

    /**
     * 活动年月
     */
    private String activityYearMonth;

}

