package com.biz.crm.tpm.business.activity.plan.sdk.dto.sfa;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author wanghaojia
 * @date 2023/1/5 15:05
 */
@Data
public class ActivityPlanItemPushSfaDto {

    /**
     * 类型 新增/变更，add/update
     */
    private String saveType;
    /**
     * 活动方案编码
     */
    private String planCode;
    /**
     * 活动方案名称
     */
    private String planName;
    /**
     * 业态 数据字典：mdm_business_format
     */
    private String businessFormatCode;
    /**
     * 方案类型 总部方案/大区方案，数据字典tpm_activity_type
     */
    private String planType;
    /**
     * 方案分类 常规/补强,数据字典tpm_activity_classify
     */
    private String planClassify;
    /**
     * 方案开始时间
     */
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date beginDate;
    /**
     * 方案结束时间
     */
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date endDate;
    /**
     * 方案主题
     */
    private String planTitle;
    /**
     * 方案目的
     */
    private String planGoal;
    /**
     * 活动背景
     */
    private String activityBackground;
    /**
     * 活动目的
     */
    private String activityTarget;
    /**
     * 明细说明
     */
    private String detailExplain;
    /**
     * 总部文件名称
     */
    private String headquarterFileName;
    /**
     * 大区文件名称
     */
    private String regionFileName;
    /**
     * 方案明细编码
     */
    private String planItemCode;
    /**
     * 活动分类编码
     */
    private String activityTypeCode;
    /**
     * 活动分类名称
     */
    private String activityTypeName;
    /**
     * 活动形式编码
     */
    private String activityFormCode;
    /**
     * 活动形式名称
     */
    private String activityFormName;
    /**
     * 活动开始时间
     */
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date activityBeginDate;
    /**
     * 活动结束时间
     */
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date activityEndDate;
    /**
     * 总部预算项目编码
     */
    private String headBudgetItemCode;
    /**
     * 总部预算项目名称
     */
    private String headBudgetItemName;
    /**
     * 大区预算项目编码
     */
    private String budgetItemCode;
    /**
     * 大区预算项目名称
     */
    private String budgetItemName;
    /**
     * 大区编码
     */
    private String regionCode;
    /**
     * 大区名称
     */
    private String regionName;
    /**
     * 省区编码
     */
    private String provinceCode;
    /**
     * 省区名称
     */
    private String provinceName;
    /**
     * 总部承担金额
     */
    private BigDecimal headFeeAmount;
    /**
     * 大区承担金额
     */
    private BigDecimal departmentFeeAmount;
    /**
     * 客户承担金额
     */
    private BigDecimal customerFeeAmount;
    /**
     * 费用合计
     */
    private BigDecimal totalFeeAmount;
    /**
     * 费用月份
     */
    @JSONField(format = "yyyy-MM")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM")
    @DateTimeFormat(pattern = "yyyy-MM")
    private Date feeYearMonth;
    /**
     * 区域编码
     */
    private String planOrgCode;
    /**
     * 区域名称
     */
    private String planOrgName;

    /**
     * SFA活动号
     */
    @ApiModelProperty(value = "SFA活动号")
    private String sfaPlanCode;
    /**
     * 实际金额
     */
    @ApiModelProperty("实际金额")
    private BigDecimal actualAmount;
    /**
     * 建议金额
     */
    @ApiModelProperty("建议金额")
    private BigDecimal suggestedAmount;


}
