package com.biz.crm.tpm.business.activity.plan.sdk.dto.sfa;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * SFA推送TPM创建活动方案Dto
 * @author wanghaojia
 * @date 2023/1/5 15:24
 */
@Data
@ApiModel(value = "SFA推送TPM创建活动方案Dto")
public class SfaActivityPlanCreateDto {

    /**
     * SFA活动号
     */
    @ApiModelProperty(value = "SFA活动号")
    private String sfaPlanCode;

    /**
     * 业态
     */
    @ApiModelProperty("业态 数据字典：mdm_business_format")
    private String businessFormatCode;
    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @ApiModelProperty("业务单元")
    private String businessUnitCode;
    /**
     * 方案类型
     */
    @ApiModelProperty("方案类型")
    private String planType;
    /**
     * 方案名称
     */
    @ApiModelProperty("方案名称")
    private String planName;
    /**
     * 方案分类
     */
    @ApiModelProperty("方案分类")
    private String planClassify;
    /**
     * 方案结束时间
     */
    @ApiModelProperty("部门编码")
    private String departmentCode;

    /**
     * 方案结束时间
     */
    @ApiModelProperty("部门名称")
    private String departmentName;
    /**
     * 方案范围编码
     */
    @ApiModelProperty("方案范围编码")
    private String planOrgCode;
    /**
     * 方案范围名称
     */
    @ApiModelProperty("方案范围名称")
    private String planOrgName;
    /**
     * 方案关联限制，数据字典tpm_activity_plan_relate_limit
     */
    @ApiModelProperty("方案关联限制，数据字典tpm_activity_plan_relate_limit")
    private String planRelateLimitCode;
    /**
     * 活动开始时间
     */
    @ApiModelProperty("活动开始时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date activityBeginDate;
    /**
     * 活动结束时间
     */
    @ApiModelProperty("活动结束时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date activityEndDate;

    /**
     * 活动分类编码
     */
    @ApiModelProperty("活动分类编码")
    private String activityTypeCode;
    /**
     * 活动分类名称
     */
    @ApiModelProperty("活动分类名称")
    private String activityTypeName;

    /**
     * 活动形式编码
     */
    @ApiModelProperty("活动形式编码")
    private String activityFormCode;
    /**
     * 活动形式名称
     */
    @ApiModelProperty("活动形式名称")
    private String activityFormName;

    /**
     * 方案开始时间
     */
    @ApiModelProperty("方案开始时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date beginDate;
    /**
     * 方案结束时间
     */
    @ApiModelProperty("方案结束时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date endDate;

    /**
     * 一级管理渠道
     */
    @ApiModelProperty("一级管理渠道")
    private String firstChannelCode;
    /**
     * 一级管理渠道
     */
    @ApiModelProperty("一级管理渠道")
    private String firstChannelName;
    /**
     * 二级管理渠道
     */
    @ApiModelProperty("二级管理渠道")
    private String secondChannelCode;
    /**
     * 二级管理渠道
     */
    @ApiModelProperty("二级管理渠道")
    private String secondChannelName;

    /**
     * MDM客户编码
     */
    @ApiModelProperty("MDM客户编码")
    private String customerCode;

    /**
     * MDG客户编码
     */
    @ApiModelProperty("MDG客户编码")
    private String customerErpCode;

    /**
     * 客户名称
     */
    @ApiModelProperty("客户名称")
    private String customerName;

    /**
     * 数量
     */
    @ApiModelProperty("数量")
    private Integer quantity;
    /**
     * 陈列数量
     */
    @ApiModelProperty("陈列数量")
    private BigDecimal displayQuantity;

    /**
     * SFA协议金额
     */
    @ApiModelProperty("SFA协议金额")
    private BigDecimal sfaFeeAmount;

    /**
     * 核销类型
     */
    @ApiModelProperty("核销类型，数据字典：tpm_audit_type")
    private String auditType;

    /**
     * 核销条件编码
     */
    @ApiModelProperty("核销条件编码")
    private String auditConditionCode;
    /**
     * 核销条件名称
     */
    @ApiModelProperty("核销条件名称")
    private String auditConditionName;
    /**
     * 销售组织编码
     */
    @ApiModelProperty("销售组织编码")
    private String activityOrgCode;
    /**
     * 销售组织名称
     */
    @ApiModelProperty("销售组织名称")
    private String activityOrgName;
    /**
     * 促销对象
     */
    @ApiModelProperty("促销对象")
    private String promotionObject;
    /**
     * 是否完全承接
     */
    @ApiModelProperty("是否完全承接")
    private String fullAccept;
    /**
     * 方案模板编码
     */
    @ApiModelProperty("方案模板编码")
    private String templateConfigCode;
    /**
     * 方案模板名称
     */
    @ApiModelProperty("方案模板名称")
    private String templateConfigName;
    /**
     * 预估销售额（万元）
     */
    @ApiModelProperty("预估销售额（万元）")
    private BigDecimal salesAmount;

}
