package com.biz.crm.tpm.business.activity.plan.sdk.dto.sfa.display;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author wanghaojia
 * @date 2023/1/5 15:05
 */
@Data
public class ActivityPlanItemPushSfaDisplayDto {

    /**
     * SFA活动号
     */
    @ApiModelProperty(value = "SFA活动号")
    private String sfaPlanCode;
    @ApiModelProperty(value = "活动方案编码")
    private String planCode;
    @ApiModelProperty(value = "活动方案名称")
    private String planName;
    @ApiModelProperty(value = "业态")
    private String businessFormatCode;
    @ApiModelProperty(value = "方案类型")
    private String planType;
    @ApiModelProperty(value = "方案分类")
    private String planClassify;
    @ApiModelProperty("方案开始时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date beginDate;
    @ApiModelProperty("方案结束时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date endDate;
    @ApiModelProperty("方案主题")
    private String planTitle;
    @ApiModelProperty("方案目的")
    private String planGoal;
    @ApiModelProperty("活动背景")
    private String activityBackground;
    @ApiModelProperty("活动目的")
    private String activityTarget;
    @ApiModelProperty("明细说明")
    private String detailExplain;
    @ApiModelProperty("活动方案明细编码")
    private String planItemCode;
    @ApiModelProperty("活动分类")
    private String activityTypeCode;
    @ApiModelProperty("活动分类名称")
    private String activityTypeName;
    @ApiModelProperty("活动形式编码")
    private String activityFormCode;
    @ApiModelProperty("活动形式名称")
    private String activityFormName;
    @ApiModelProperty("活动开始时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date activityBeginDate;
    @ApiModelProperty("活动结束时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date activityEndDate;
    @ApiModelProperty("总部预算项目编码")
    private String headBudgetItemCode;
    @ApiModelProperty("总部预算项目名称")
    private String headBudgetItemName;
    @ApiModelProperty("大区预算项目编码")
    private String budgetItemCode;
    @ApiModelProperty("大区预算项目名称")
    private String budgetItemName;
    @ApiModelProperty("所属销售大区编码")
    private String salesRegionCode;
    @ApiModelProperty("所属销售大区编码")
    private String salesRegionName;
    @ApiModelProperty("所属销售大区ERP编码")
    private String salesRegionErpCode;
    @ApiModelProperty("所属销售组织(组)编码，省区")
    private String salesOrgCode;
    @ApiModelProperty("所属销售组织(组)名称，省区")
    private String salesOrgName;
    @ApiModelProperty("所属销售组织(组)编码，省区")
    private String salesOrgErpCode;
    @ApiModelProperty("总部承担金额")
    private BigDecimal headFeeAmount;
    @ApiModelProperty("大区承担金额")
    private BigDecimal departmentFeeAmount;
    @ApiModelProperty("客户承担金额")
    private BigDecimal customerFeeAmount;
    @ApiModelProperty("费用合计")
    private BigDecimal totalFeeAmount;
    @ApiModelProperty("TPM预估费用")
    private BigDecimal feeAmount;
    @ApiModelProperty("SFA协议金额")
    private BigDecimal sfaFeeAmount;
    @ApiModelProperty("费用所属年月")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM")
    @DateTimeFormat(pattern = "yyyy-MM")
    private Date feeYearMonth;

}
