package com.biz.crm.tpm.business.activity.plan.sdk.enums;

import jodd.util.StringUtil;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 活动类型枚举
 *
 * @author wanghaojia
 * @date 2022/11/23 12:55
 */
@Getter
@AllArgsConstructor
public enum ActivityPlanTypeEnum {

    headquarters("headquarters", "总部方案"),
    region("region", "大区方案"),
    ;

    private final String code;

    private final String name;


    public static ActivityPlanTypeEnum codeToEnum(String code) {
        if (StringUtil.isEmpty(code)){
            return null;
        }
        for (ActivityPlanTypeEnum typeEnum : values()) {
            if (typeEnum.code.equals(code)) {
                return typeEnum;
            }
        }
        return null;
    }

}
