package com.biz.crm.tpm.business.activity.plan.sdk.enums;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;
import jodd.util.StringUtil;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 活动方案来源
 * @author wanghaojia
 * @date 2023/7/6 16:26
 */
@Getter
@AllArgsConstructor
public enum ActivityPlanWhereFrom {

    /**
     * 手动新增
     */
    MANUAL("manual", "手动新增"),
    KMS("kms", "稽核匹配"),
    UnmatchedCostDoc("UnmatchedCostDoc", "未匹配费用单"),
    UnmatchedStatement("UnmatchedStatement", "未匹配结算单"),
    ;

    private final String code;
    private final String des;

    public static ActivityPlanWhereFrom codeToEnum(String code) {
        if (StringUtil.isEmpty(code)){
            return null;
        }
        for (ActivityPlanWhereFrom typeEnum : values()) {
            if (typeEnum.code.equals(code)) {
                return typeEnum;
            }
        }
        return null;
    }

}
