package com.biz.crm.tpm.business.activity.plan.sdk.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * @author ：dengwei
 * @date ：Created in 2023/1/17 19:20
 * @description：活动方案细案垂直搭赠类型
 */
@Getter
@AllArgsConstructor
public enum BonusTypeEnum {

    BONUS("1", "搭赠"),
    PURE_SEND("2", "纯赠"),
    OTHER("3", "其他"),
    ;
    private String code;
    private String desc;

    public static BonusTypeEnum findByDesc(String desc) {
        if (StringUtils.isBlank(desc)) {
            return null;
        }
        for (BonusTypeEnum type : values()) {
            if (StringUtils.equals(type.getDesc(), desc)) {
                return type;
            }
        }
        return null;
    }
}
