package com.biz.crm.tpm.business.activity.plan.sdk.enums;


import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;
import org.apache.commons.lang3.StringUtils;

import java.util.HashSet;
import java.util.Set;

/**
 * 细案明细推送外部系统状态枚举
 * @author : qiancheng
 * @date : 2022-12-20
 */
public enum InterfacePushStateEnum {

    /**
     * 新增明细的默认状态
     */
    NOT_PUSH("0","未推送"),
    /**
     * 回调接口返回推送失败结果，明细状态
     */
    FAIL("1","推送失败"),
    /**
     * 回调接口返回推送成功结果，明细状态
     */
    SUCCESS("2","推送成功");

    @EnumValue
    @JsonValue
    private String code;
    private String des;

    private InterfacePushStateEnum(String code, String des) {
        this.code = code;
        this.des = des;
    }

    public String getCode() {
        return this.code;
    }

    public String getDes() {
        return this.des;
    }

    public static Set<String> codeToSet() {
        Set<String> codes = new HashSet();
        InterfacePushStateEnum[] var1 = values();
        int var2 = var1.length;

        for(int var3 = 0; var3 < var2; ++var3) {
            InterfacePushStateEnum orderShareInterfaceStateEnum = var1[var3];
            codes.add(orderShareInterfaceStateEnum.getCode());
        }

        return codes;
    }

    public static InterfacePushStateEnum codeToEnum(String code) {
        InterfacePushStateEnum orderShareInterfaceState = null;
        InterfacePushStateEnum[] var2 = values();
        int var3 = var2.length;

        for(int var4 = 0; var4 < var3; ++var4) {
            InterfacePushStateEnum orderShareInterfaceStateEnum = var2[var4];
            if (orderShareInterfaceStateEnum.code.equals(code)) {
                orderShareInterfaceState = orderShareInterfaceStateEnum;
            }
        }

        return orderShareInterfaceState;
    }

    public static String getDesc(String code) {
        if (!StringUtils.isEmpty(code)) {
            InterfacePushStateEnum[] values = values();
            InterfacePushStateEnum[] var2 = values;
            int var3 = values.length;

            for(int var4 = 0; var4 < var3; ++var4) {
                InterfacePushStateEnum value = var2[var4];
                if (value.code.equals(code)) {
                    return value.des;
                }
            }
        }

        return null;
    }

    public static boolean contains(String code) {
        if (StringUtils.isEmpty(code)) {
            return false;
        } else {
            InterfacePushStateEnum[] values = values();
            InterfacePushStateEnum[] var2 = values;
            int var3 = values.length;

            for(int var4 = 0; var4 < var3; ++var4) {
                InterfacePushStateEnum value = var2[var4];
                if (value.getCode().equals(code)) {
                    return true;
                }
            }

            return false;
        }
    }

}
