package com.biz.crm.tpm.business.activity.plan.sdk.enums;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;
import lombok.AllArgsConstructor;
import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

import java.util.HashSet;
import java.util.Set;

/**
 * @Description: 主体活动 方案促销类型枚举 字典编码 tpm_activity_plan_promotion_type
 * @Author qiancheng
 * @Date 2023/2/10
 */
@Getter
@AllArgsConstructor
public enum PromotionTypeEnum {

    PROMOTION_GIFT("1","随车搭赠"),
    GIVE_FIRST_THEN_ASSESS("2","先搭赠后考核"),
    END_BACK("3","后返"),
//    FREE_RIDE("4","随车搭赠"),
    ;

    @EnumValue
    @JsonValue
    private String code;
    private String des;

    public static Set<String> codeToSet() {
        Set<String> codes = new HashSet();
        for (PromotionTypeEnum typeEnum : values()) {
            codes.add(typeEnum.getCode());
        }
        return codes;
    }

    public static PromotionTypeEnum codeToEnum(String code) {
        if (StringUtils.isEmpty(code)) {
            return null;
        }
        for (PromotionTypeEnum typeEnum : values()) {
            if (typeEnum.getCode().equals(code)) {
                return typeEnum;
            }
        }
        return null;
    }

    public static String getDesc(String code) {
        if (StringUtils.isEmpty(code)) {
            return null;
        }
        for (PromotionTypeEnum typeEnum : values()) {
            if (typeEnum.getCode().equals(code)) {
                return typeEnum.getDes();
            }
        }
        return null;
    }

    public static boolean contains(String code) {
        if (StringUtils.isEmpty(code)) {
            return false;
        }
        for (PromotionTypeEnum typeEnum : values()) {
            if (typeEnum.getCode().equals(code)) {
                return true;
            }
        }
        return false;
    }
}
