package com.biz.crm.tpm.business.activity.plan.sdk.enums;

import lombok.Getter;

/**
 * @Description: sap回调结果标记枚举
 * @Author qiancheng
 * @Date 2023/3/1
 */
public enum SapInterfaceEnum {
    /**
     * 回调结果
     */
    SUCCESS("S","成功"),
    FAIL("E","失败"),

    /**
     * 活动状态
     */
    VALID("1","有效"),
    INVALID("2","无效"),

    /**
     * 核销方式 事中
     */
    THINGS("1","SZ"),
    /**
     * 核销方式 事后
     */
    AFTER_THE_EVENT("2","SH");

    @Getter
    private String code;
    @Getter
    private String value;

    SapInterfaceEnum(String code, String value){
        this.code = code;
        this.value = value;
    }
}
