package com.biz.crm.tpm.business.activity.plan.sdk.enums;

import lombok.Getter;

/**
 * @Description: TPM核销类型枚举
 * @Author qiancheng
 * @Date 2023/2/10
 */
@Getter
public enum TpmAuditTypeEnum {

    AUDITTYPE1("1","制度核销"),
    AUDITTYPE2("2","自定义核销"),
    AUDITTYPE3("no_dudit_condition","无核销条件"),
    ;

    private String code;
    private String value;

    TpmAuditTypeEnum(String code, String value){
        this.code = code;
        this.value = value;
    }

    public static String getDescByCode(String code){
        for (TpmAuditTypeEnum value : TpmAuditTypeEnum.values()) {
            if(value.getCode().equals(code)){
                return value.getValue();
            }
        }
        return null;
    }

    public static String getCodeByDesc(String desc){
        for (TpmAuditTypeEnum value : TpmAuditTypeEnum.values()) {
            if(value.getValue().equals(desc)){
                return value.getCode();
            }
        }
        return null;
    }
}
