package com.biz.crm.tpm.business.activity.plan.sdk.event.log;

import com.biz.crm.tpm.business.activity.plan.sdk.dto.log.ActivityPlanItemCloseLogEventDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.log.ActivityPlanItemLogEventDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.log.ActivityPlanLogEventDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.log.ActivityPlanModifyLogEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaEvent;

/**
 * 日志监听
 *
 * @author: yaoyongming
 * @date: 2023/1/9 20:10
 */
public interface ActivityPlanLogEventListener extends NebulaEvent {
    /**
     * 创建事件
     *
     * @param eventDto
     */
    void onCreate(ActivityPlanLogEventDto eventDto);
    /**
     * 创建事件
     *
     * @param eventDto
     */
    void onCreateModify(ActivityPlanModifyLogEventDto eventDto);
    /**
     * 删除事件
     *
     * @param eventDto
     */
    void onDelete(ActivityPlanLogEventDto eventDto);
    /**
     * 删除事件
     *
     * @param eventDto
     */
    void onDeleteModify(ActivityPlanModifyLogEventDto eventDto);
    /**
     * 更新日志
     *
     * @param eventDto
     */
    void onUpdate(ActivityPlanLogEventDto eventDto);
    /**
     * 更新日志
     *
     * @param eventDto
     */
    void onUpdateModify(ActivityPlanModifyLogEventDto eventDto);
    /**
     * 关闭日志
     *
     * @param eventDto
     */
    void onClosed(ActivityPlanLogEventDto eventDto);

    /**
     * 明细关闭记录日志
     */
    void onCloseItem(ActivityPlanItemCloseLogEventDto eventDto);

}
