package com.biz.crm.tpm.business.activity.plan.sdk.listener;

import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityDetailPlanPlanEventDto;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityDetailPlanPlanResponse;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanNoCloseItemResponse;
import com.bizunited.nebula.event.sdk.service.NebulaEvent;

import java.util.List;

/**
 * 查询活动细案关系 对外提供事件
 *
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2023.2.26 18:09
 */
public interface ActivityDetailPlanPlanListener extends NebulaEvent {


    void validateCloseActivityPlanItem(ActivityDetailPlanPlanEventDto dto);

    /**
     * 活动方案关闭后同步关闭活动细案
     */
    void closeActivityDetailPlanItem(ActivityDetailPlanPlanEventDto dto);

    /**
     * 查询可关闭的方案明细编码（无细案关联，或已关联的细案完全关闭）
     *
     * @param dto 方案明细编码
     * @return List<String>
     **/
    ActivityPlanNoCloseItemResponse getNoClosePlanItemNo(ActivityDetailPlanPlanEventDto dto);

}
