package com.biz.crm.tpm.business.activity.plan.sdk.listener.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.math.BigDecimal;

/**
 * 活动方案查询方案预测Response
 * @author wanghaojia
 * @date 2023/8/23 09:51
 */
@Getter
@Setter
@AllArgsConstructor
@NoArgsConstructor
public class ActivityPlanQuerySchemeForecastCashVo {

    @ApiModelProperty(name = "schemeForecastId", notes = "方案预测id")
    private String schemeForecastId;

    @ApiModelProperty(name = "schemeForecastCode", notes = "方案预测编码")
    private String schemeForecastCode;

    @ApiModelProperty(name = "schemeCode", notes = "方案编码")
    private String schemeCode;

    @ApiModelProperty(name = "schemeItemCode", notes = "方案明细编码")
    private String schemeItemCode;

    @ApiModelProperty(name = "detailCode", notes = "明细编码")
    private String detailCode;

    @ApiModelProperty("预算项目")
    private String budgetItemCode;

    @ApiModelProperty("预算项目")
    private String budgetItemName;

    @ApiModelProperty("预算编码")
    private String budgetCode;

    @ApiModelProperty(name = "confirmAmount",notes = "确认金额")
    private BigDecimal confirmAmount;

    @ApiModelProperty(name = "usedAmount",notes = "已使用金额")
    private BigDecimal usedAmount;

    @ApiModelProperty(name = "balanceAmount",notes = "剩余可使用金额")
    private BigDecimal balanceAmount;

    @ApiModelProperty(name = "actFrozenAmount",notes = "申请时冻结金额")
    private BigDecimal actFrozenAmount;

    @ApiModelProperty(name = "overFrozenAmount",notes = "补冻结金额")
    private BigDecimal overFrozenAmount;

}
