package com.biz.crm.tpm.business.activity.plan.sdk.modify.dto;

import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanBudgetDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanItemTerminalDto;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.pojo.ActivityPlanItemModifyBase;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.util.List;

/**
 * 活动方案明细调整表Vo
 * @author wanghaojia
 * @date 2022/12/6 14:41
 */
@ApiModel(value = "ActivityPlanItemModifyDto", description = "活动方案明细调整表Dto")
@Getter
@Setter
public class ActivityPlanItemModifyDto extends ActivityPlanItemModifyBase {


    /**
     * 行索引
     */
    @ApiModelProperty("行索引")
    private Integer indexNo;

    /**
     * 预算使用信息
     */
    @ApiModelProperty("预算使用信息")
    private List<ActivityPlanBudgetModifyDto> budgetShares;


    /**
     * 门店明细
     */
    @ApiModelProperty("门店明细")
    private List<ActivityPlanItemTerminalModifyDto> activityPlanItemTerminalList;


    /**
     * 变更编码集合
     */
    @ApiModelProperty("变更编码集合")
    private List<String> modifyBusinessCodeList;

}
