package com.biz.crm.tpm.business.activity.plan.sdk.modify.enums;

import com.biz.crm.tpm.business.activity.plan.sdk.modify.constant.ActivityPlanModifyMqConstant;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 分子公司细案变更审批通过调用mq tag枚举
 * @author wanghaojia
 * @date 2023/1/16 21:00
 */
@AllArgsConstructor
@Getter
public enum ActivityPlanModifyMqTagEnum {

    PASS_UPDATE_ORIGIN(ActivityPlanModifyMqConstant.PASS_UPDATE_ORIGIN,"活动方案变更审批通过更新细案数据", PushType.code),
    //自动变更自动生成的活动细案
    PASS_UPDATE_DETAIL_PLAN(ActivityPlanModifyMqConstant.PASS_UPDATE_DETAIL_PLAN,"活动方案变更审批通过自动变更自动生成的细案", PushType.after_update_origin),
    PASS_PUSH_SAP(ActivityPlanModifyMqConstant.PASS_PUSH_SAP,"活动方案变更审批通过推送SAP", PushType.after_update_origin),
    PASS_UPDATE_CLOSE_CECORD_DETAIL(ActivityPlanModifyMqConstant.PASS_UPDATE_CLOSE_CECORD_DETAIL,"活动方案变更审批通过自动变更方案预算跟踪表", PushType.after_update_origin),
    ;

    private final String code;

    private final String name;

    private final PushType pushType;

    public enum PushType{
        code,after_update_origin
    }

}
