package com.biz.crm.tpm.business.activity.plan.sdk.modify.pojo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author wanghaojia
 * @date 2023/2/24 11:31
 */
@Data
public class ActivityPlanItemModifySelf {

    /**
     * 变更编码
     */
    @ApiModelProperty("变更编码")
    private String modifyBusinessCode;

    /**
     * 活动方案编码
     */
    @ApiModelProperty("活动方案编码")
    private String planCode;
    /**
     * 活动方案明细编码
     */
    @ApiModelProperty("活动方案明细编码")
    private String planItemCode;


    /**
     * 活动开始时间
     */
    @ApiModelProperty("活动开始时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date activityBeginDate;
    /**
     * 活动结束时间
     */
    @ApiModelProperty("活动结束时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date activityEndDate;

    /**
     * 订单开始时间
     */
    @ApiModelProperty("订单开始时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date orderBeginDate;
    /**
     * 订单结束时间
     */
    @ApiModelProperty("订单结束时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date orderEndDate;
    /**
     * 数量
     */
    @ApiModelProperty("数量")
    private Integer quantity;
    /**
     * 预估销售额
     */
    @ApiModelProperty("预估销售额")
    private BigDecimal salesAmount;
    /**
     * 期间促销件数
     */
    @ApiModelProperty("期间促销件数")
    private Integer periodPromotionalNumber;
    /**
     * 期间促销金额
     */
    @ApiModelProperty("期间促销金额")
    private BigDecimal periodPromotionalAmount;

    /**
     * 预估费用 -我方承担金额
     */
    @ApiModelProperty("预估费用 -我方承担金额")
    private BigDecimal feeAmount;
    /**
     * 总部承担金额
     */
    @ApiModelProperty("总部承担金额")
    private BigDecimal headFeeAmount;
    /**
     * 已发生总部费用
     */
    @ApiModelProperty("已发生总部费用")
    private BigDecimal usedHeadFeeAmount;
    /**
     * 大区承担金额
     */
    @ApiModelProperty("大区承担金额")
    private BigDecimal departmentFeeAmount;
    /**
     * 已发生大区费用
     */
    @ApiModelProperty("已发生大区费用")
    private BigDecimal usedDepartmentFeeAmount;
    /**
     * 客户承担金额
     */
    @ApiModelProperty("客户承担金额")
    private BigDecimal customerFeeAmount;
    /**
     * 已发生客户费用
     */
    @ApiModelProperty("已发生客户费用")
    private BigDecimal usedCustomerFeeAmount;
    /**
     * 费用合计
     */
    @ApiModelProperty("费用合计")
    private BigDecimal totalFeeAmount;

    /**
     * 大区公投预算金额
     */
    @ApiModelProperty("大区公投预算金额（元）")
    private BigDecimal regionReferendumFeeAmount;

    /**
     * 大区自投预算金额
     */
    @ApiModelProperty("大区自投预算金额（元）")
    private BigDecimal regionAutomaticFeeAmount;

    @ApiModelProperty("是否扣减费用池")
    private String isDeductionFeePool;
    /**
     * 核销类型
     */
    @ApiModelProperty("核销类型")
    private String auditType;
    /**
     * 核销条件编码
     */
    @ApiModelProperty("核销条件编码")
    private String auditConditionCode;
    /**
     * 核销条件名称
     */
    @ApiModelProperty("核销条件名称")
    private String auditConditionName;


}
