package com.biz.crm.tpm.business.activity.plan.sdk.modify.service;

import com.biz.crm.tpm.business.activity.plan.sdk.modify.dto.ActivityPlanItemModifyDto;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.dto.ActivityPlanItemTerminalModifyDto;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.vo.ActivityPlanModifyVo;

import java.util.List;

/**
 * 方案调整sdk
 * @author wanghaojia
 * @date 2023/4/26 14:46
 */
public interface ActivityPlanModifySdkService {

    /**
     * 通过id获取活动方案变更数据
     */
    ActivityPlanModifyVo findById(String id);

    /**
     * 通过id或编码获取活动方案变更数据
     */
    ActivityPlanModifyVo findByIdOrCode(String id, String code);

    /**
     * 查询明细行信息
     */
    List<ActivityPlanItemModifyDto> findItemDtoAndAttachListByModifyCode(String modifyBusinessCode);

    /**
     * 查询明细行关联门店信息
     */
    List<ActivityPlanItemTerminalModifyDto> findTerminalListByModifyBusinessCode(String modifyBusinessCode);

    List<ActivityPlanItemModifyDto> findDtoListByModifyCode(String businessNo);
}
