package com.biz.crm.tpm.business.activity.plan.sdk.modify.vo;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author ：dengwei
 * @date ：Created in 2023/1/12 10:40
 * @description：方案明细门店
 */
@ApiModel(value = "ActivityPlanItemTerminalModifyVo", description = "方案明细门店")
@Getter
@Setter
public class ActivityPlanItemTerminalModifyVo extends TenantFlagOpVo {
    /**
     * 活动方案编码
     */
    @ApiModelProperty("方案变更编码")
    private String modifyBusinessCode;
    /**
     * 活动方案编码
     */
    @ApiModelProperty("活动方案编码")
    private String planCode;
    /**
     * 活动方案明细编码
     */
    @ApiModelProperty("活动方案明细编码")
    private String planItemCode;


    /**
     * 门店编码
     */
    @ApiModelProperty(name = "门店编码", notes = "门店编码")
    private String terminalCode;

    /**
     * 门店名称
     */
    @ApiModelProperty(name = "门店名称", notes = "门店名称")
    private String terminalName;

    @ApiModelProperty(name = "responsibleBusiness", notes = "责任业务")
    private String responsibleBusiness;

    @ApiModelProperty(name = "responsibleSupervision", notes = "责任督导")
    private String responsibleSupervision;

    @ApiModelProperty(name = "name", notes = "用户姓名")
    private String name;

    @ApiModelProperty(name = "empId", notes = "empId")
    private String empId;

    @ApiModelProperty(name = "employeeCode", notes = "员工号")
    private String employeeCode;

    @ApiModelProperty(name = "beginDate", notes = "促销人员开始时间")
    private Date beginDate;

    @ApiModelProperty(name = "endDate", notes = "促销人员结束时间")
    private Date endDate;


    @ApiModelProperty(name = "phone", notes = "手机号")
    private String phone;

    @ApiModelProperty(name = "identityCard", notes = "身份证号")
    private String identityCard;

    @ApiModelProperty("标准")
    private BigDecimal standard;

    @ApiModelProperty("数量")
    private BigDecimal quantity;

    @ApiModelProperty("金额(费用合计)")
    private BigDecimal amount;

    @ApiModelProperty("浮动率")
    private BigDecimal floatingRate;


    /*********************冗余**************************/
    @ApiModelProperty("活动细案明细编码")
    private String detailPlanItemCode;

    @ApiModelProperty("是否选中 0否1是")
    private String checked;

    @JsonIgnore
    @ApiModelProperty("复制的明细表的id")
    private String copyId;
}
