package com.biz.crm.tpm.business.activity.plan.sdk.pojo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author wanghaojia
 * @date 2023/2/24 11:07
 */
@Data
public class ActivityPlanBase {

    @ApiModelProperty(name = "id", value = "主键ID")
    private String id;
    @ApiModelProperty(name = "createAccount", value = "创建人账号")
    private String createAccount;
    @ApiModelProperty(name = "createTime", value = "创建时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;
    @ApiModelProperty(name = "createName", value = "创建人名称")
    private String createName;
    @ApiModelProperty(name = "modifyAccount", value = "更新人账号")
    private String modifyAccount;
    @ApiModelProperty(name = "modifyTime", value = "最后更新时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date modifyTime;
    @ApiModelProperty(name = "modifyName", value = "修改人名称")
    private String modifyName;
    @ApiModelProperty(name = "delFlag", value = "删除状态，003已删除，009未删除")
    private String delFlag;
    @ApiModelProperty(name = "enableStatus", value = "启禁用状态，003禁用，009启用")
    private String enableStatus;
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;
    @ApiModelProperty(name = "tenantCode", value = "租户编号")
    private String tenantCode;


    /**
     * 方案编码
     */
    @ApiModelProperty("方案编码")
    private String planCode;

    /**
     * 方案明细编码
     */
    @ApiModelProperty("方案明细编码")
    private String planItemCode;

    /**
     * 关联方案编码
     */
    @ApiModelProperty("关联方案编码")
    private String relatePlanCode;

    /**
     * 关联方案明细编码
     */
    @ApiModelProperty("关联方案明细编码")
    private String relatePlanItemCode;

    /**
     * 方案名称
     */
    @ApiModelProperty("方案名称")
    private String planName;
    /**
     * 方案类型
     */
    @ApiModelProperty("方案类型")
    private String planType;

    /**
     * 业态
     */
    @ApiModelProperty("业态 数据字典：mdm_business_format")
    private String businessFormatCode;
    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @ApiModelProperty("业务单元")
    private String businessUnitCode;
    /**
     * 方案结束时间
     */
    @ApiModelProperty("部门编码")
    private String departmentCode;

    /**
     * 方案结束时间
     */
    @ApiModelProperty("部门名称")
    private String departmentName;
    /**
     * 方案开始时间
     */
    @ApiModelProperty("方案开始时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date beginDate;
    private String beginDateStr;
    /**
     * 方案结束时间
     */
    @ApiModelProperty("方案结束时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date endDate;
    private String endDateStr;
    /**
     * 方案范围编码
     */
    @ApiModelProperty("方案范围编码")
    private String planOrgCode;
    /**
     * 方案范围编码
     */
    @ApiModelProperty("方案范围ERP编码")
    private String planOrgErpCode;
    /**
     * 方案范围名称
     */
    @ApiModelProperty("方案范围名称")
    private String planOrgName;
    /**
     * 方案分类
     */
    @ApiModelProperty("方案分类")
    private String planClassify;
    /**
     * 方案关联限制，数据字典tpm_activity_plan_relate_limit
     */
    @ApiModelProperty("方案关联限制，数据字典tpm_activity_plan_relate_limit")
    private String planRelateLimitCode;
    /**
     * 活动状态
     */
    @ApiModelProperty("活动状态")
    private String planStatus;

    /**
     * 预估费用 -我方承担金额
     */
    @ApiModelProperty("预估费用 -我方承担金额")
    private BigDecimal feeAmount;
    /**
     * 预估费用 -我方承担金额-字符串，前端用
     */
    @ApiModelProperty("预估费用 -我方承担金额-字符串，前端用")
    private String feeAmountStr;
    /**
     * 总部承担金额
     */
    @ApiModelProperty("总部承担金额")
    private BigDecimal headFeeAmount;
    /**
     * 总部承担金额-字符串，前端用
     */
    @ApiModelProperty("总部承担金额-字符串，前端用")
    private String headFeeAmountStr;
    /**
     * 大区承担金额
     */
    @ApiModelProperty("大区承担金额")
    private BigDecimal departmentFeeAmount;
    /**
     * 大区承担金额-字符串，前端用
     */
    @ApiModelProperty("大区承担金额-字符串，前端用")
    private String departmentFeeAmountStr;
    /**
     * 客户承担金额
     */
    @ApiModelProperty("客户承担金额")
    private BigDecimal customerFeeAmount;
    /**
     * 客户承担金额-字符串，前端用
     */
    @ApiModelProperty("客户承担金额-字符串，前端用")
    private String customerFeeAmountStr;
    /**
     * 费用合计
     */
    @ApiModelProperty("费用合计")
    private BigDecimal totalFeeAmount;
    /**
     * 费用合计-字符串，前端用
     */
    @ApiModelProperty("费用合计-字符串，前端用")
    private String totalFeeAmountStr;
    /**
     * 大区公投预算金额
     */
    @ApiModelProperty("大区公投预算金额（元）")
    private BigDecimal regionReferendumFeeAmount;

    /**
     * 大区自投预算金额
     */
    @ApiModelProperty("大区自投预算金额（元）")
    private BigDecimal regionAutomaticFeeAmount;
    /**
     * 预估销售额（万元）
     */
    @ApiModelProperty("预估销售额（万元）")
    private BigDecimal salesAmount;
    /**
     * 方案投产比
     */
    @ApiModelProperty("方案投产比")
    private BigDecimal planIoRate;
    /**
     * 方案主题
     */
    @ApiModelProperty("方案主题")
    private String planTitle;
    /**
     * 方案目的
     */
    @ApiModelProperty("方案目的")
    private String planGoal;
    /**
     * 活动背景
     */
    @ApiModelProperty("活动背景")
    private String activityBackground;
    /**
     * 活动目标
     */
    @ApiModelProperty("活动目标")
    private String activityTarget;
    /**
     * 明细说明
     */
    @ApiModelProperty("明细说明")
    private String detailExplain;
    /**
     * 是否完全承接
     */
    @ApiModelProperty("是否完全承接")
    private String fullAccept;

    /**
     * 方案模板编码
     */
    @ApiModelProperty("方案模板编码")
    private String templateConfigCode;

    /**
     * 方案模板名称
     */
    @ApiModelProperty("方案模板名称")
    private String templateConfigName;

    /**
     * 流程编号
     */
    @ApiModelProperty("流程编号")
    private String processNo;
    /**
     * 审批状态
     */
    @ApiModelProperty("审批状态")
    private String processStatus;

    @ApiModelProperty(name = "whereFrom",value = "来源",notes = "来源")
    private String whereFrom;

    /**
     * 是否变更过Y/N
     */
    private String hasModify;

    /**
     * 是否跨月策略
     */
    @ApiModelProperty(name = "是否跨月策略", notes = "")
    private String isCrossMonth;

    /**
     * 联合方案申请
     */
    @ApiModelProperty(name = "联合方案申请", notes = "")
    private String unitedProgressApply;

    /**
     * 调整前版本号
     */
    @ApiModelProperty("调整前变更编码")
    private String currModifyBusinessCode;

}
