package com.biz.crm.tpm.business.activity.plan.sdk.pojo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Transient;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author wanghaojia
 * @date 2023/2/24 11:07
 */
@Data
public class ActivityPlanItemBase extends ActivityPlanItemExtendFieldBase {

    @ApiModelProperty(name = "id", value = "主键ID")
    private String id;
    @ApiModelProperty(name = "createAccount", value = "创建人账号")
    private String createAccount;
    @ApiModelProperty(name = "createTime", value = "创建时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;
    @ApiModelProperty(name = "createName", value = "创建人名称")
    private String createName;
    @ApiModelProperty(name = "modifyAccount", value = "更新人账号")
    private String modifyAccount;
    @ApiModelProperty(name = "modifyTime", value = "最后更新时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date modifyTime;
    @ApiModelProperty(name = "modifyName", value = "修改人名称")
    private String modifyName;
    @ApiModelProperty(name = "delFlag", value = "删除状态，003已删除，009未删除")
    private String delFlag;
    @ApiModelProperty(name = "enableStatus", value = "启禁用状态，003禁用，009启用")
    private String enableStatus;
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;
    @ApiModelProperty(name = "tenantCode", value = "租户编号")
    private String tenantCode;
    /**
     * 活动方案编码
     */
    @ApiModelProperty("活动方案编码")
    private String planCode;
    /**
     * 活动方案编码
     */
    @ApiModelProperty("活动方案名称")
    private String planName;
    /**
     * 活动方案明细编码
     */
    @ApiModelProperty("活动方案明细编码")
    private String planItemCode;

    /**
     * 方案模板编码
     */
    @ApiModelProperty("方案模板编码")
    private String templateConfigCode;

    /**
     * 活动类型编码
     */
    @ApiModelProperty("活动类型编码")
    private String activityTypeCode;
    /**
     * 活动类型名称
     */
    @ApiModelProperty("活动类型名称")
    private String activityTypeName;
    /**
     * 活动类型-前端用
     */
    @ApiModelProperty("活动类型-前端用")
    private String activityType;
    /**
     * 活动形式编码
     */
    @ApiModelProperty("活动形式编码")
    private String activityFormCode;
    /**
     * 活动形式名称
     */
    @ApiModelProperty("活动形式名称")
    private String activityFormName;
    /**
     * 活动形式-前端用
     */
    @ApiModelProperty("活动形式-前端用")
    private String activityForm;
    /**
     * 活动开始时间
     */
    @ApiModelProperty("活动开始时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date activityBeginDate;
    /**
     * 活动开始时间-字符串，前端用
     */
    @ApiModelProperty("活动开始时间-字符串，前端用")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private String activityBeginDateStr;
    /**
     * 活动结束时间
     */
    @ApiModelProperty("活动结束时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date activityEndDate;
    /**
     * 活动结束时间-字符串，前端用
     */
    @ApiModelProperty("活动结束时间-字符串，前端用")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private String activityEndDateStr;

    /**
     * 订单开始时间
     */
    @ApiModelProperty("订单开始时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date orderBeginDate;
    /**
     * 订单结束时间
     */
    @ApiModelProperty("订单结束时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date orderEndDate;
    /**
     * 订单开始时间-字符串，前端用
     */
    @ApiModelProperty("订单开始时间-字符串，前端用")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private String orderBeginDateStr;
    /**
     * 订单结束时间-字符串，前端用
     */
    @ApiModelProperty("订单结束时间-字符串，前端用")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private String orderEndDateStr;
    /**
     * 一级管理渠道
     */
    @ApiModelProperty("一级管理渠道")
    private String firstChannelCode;
    /**
     * 一级管理渠道
     */
    @ApiModelProperty("一级管理渠道")
    private String firstChannelName;
    /**
     * 二级管理渠道
     */
    @ApiModelProperty("二级管理渠道")
    private String secondChannelCode;
    /**
     * 二级管理渠道
     */
    @ApiModelProperty("二级管理渠道")
    private String secondChannelName;

    @ApiModelProperty("分销渠道编码")
    @Column(name = "distribution_channel_code", length = 32, columnDefinition = "varchar(32) COMMENT '分销渠道编码'")
    private String distributionChannelCode;

    @ApiModelProperty("分销渠道名称")
    @Column(name = "distribution_channel_name", length = 32, columnDefinition = "varchar(32) COMMENT '分销渠道名称'")
    private String distributionChannelName;

    /**
     * 关联策略编码
     */
    @ApiModelProperty("关联策略编码")
    private String relateStrategyCode;
    /**
     * 关联策略明细编码
     */
    @ApiModelProperty("关联策略明细编码")
    private String relateStrategyItemCode;
    /**
     * 上级方案编码
     */
    @ApiModelProperty("上级方案编码")
    private String relatePlanCode;
    /**
     * 上级方案明细编码
     */
    @ApiModelProperty("上级方案明细编码")
    private String relatePlanItemCode;

    /**
     * 总部预算编码
     */
    @ApiModelProperty("总部预算编码")
    private String headMonthBudgetCode;
    /**
     * 总部预算项目编码
     */
    @ApiModelProperty("总部预算项目编码")
    private String headBudgetItemCode;

    /**
     * 总部预算项目名称
     */
    @ApiModelProperty("总部预算项目名称")
    private String headBudgetItemName;
    /**
     * 大区公投预算编码
     */
    @ApiModelProperty(value = "大区公投预算编码", notes = "")
    private String regionReferendumMonthBudgetCode;

    /**
     * 大区公投项目编码
     */
    @ApiModelProperty(value = "大区公投预算项目编码", notes = "")
    private String regionReferendumBudgetItemCode;

    /**
     * 大区公投预算项目名称
     */
    @ApiModelProperty(value = "大区公投预算项目名称", notes = "")
    private String regionReferendumBudgetItemName;

    /**
     * 大区公投预算编码
     */
    @ApiModelProperty(value = "大区自投预算编码", notes = "")
    private String regionAutomaticMonthBudgetCode;

    /**
     * 大区公投项目编码
     */
    @ApiModelProperty(value = "大区自投预算项目编码", notes = "")
    private String regionAutomaticBudgetItemCode;

    /**
     * 大区公投预算项目名称
     */
    @ApiModelProperty(value = "大区自投预算项目名称", notes = "")
    private String regionAutomaticBudgetItemName;
    /**
     * 大区预算编码
     */
    @ApiModelProperty("大区预算编码")
    private String monthBudgetCode;

    /**
     * 大区预算项目编码
     */
    @ApiModelProperty("大区预算项目编码")
    private String budgetItemCode;

    /**
     * 大区预算项目名称
     */
    @ApiModelProperty("大区预算项目名称")
    private String budgetItemName;

    /**
     * 销售组织编码
     */
    @ApiModelProperty("销售组织编码")
    private String activityOrgCode;

    /**
     * 销售组织erp编码
     */
    @ApiModelProperty("销售组织erp编码")
    private String activityOrgErpCode;

    /**
     * 销售组织名称
     */
    @ApiModelProperty("销售组织名称")
    private String activityOrgName;
    /**
     * 促销对象
     */
    @ApiModelProperty("促销对象")
    private String promotionObject;
    /**
     * 系统
     */
    @ApiModelProperty("系统/零售商编码")
    private String systemCode;
    /**
     * 系统
     */
    @ApiModelProperty("系统/零售商名称")
    private String systemName;
    /**
     * 数量
     */
    @ApiModelProperty("数量")
    private Integer quantity;
    /**
     * 数量-字符串，前端用
     */
    @ApiModelProperty("数量-字符串，前端用")
    private String quantityStr;

    /**
     * 预估销售额
     */
    @ApiModelProperty("预估销售额")
    private BigDecimal salesAmount;
    /**
     * 预估销售额-字符串，前端用
     */
    @ApiModelProperty("预估销售额-字符串，前端用")
    private String salesAmountStr;

    /**
     * 单店金额
     */
    @ApiModelProperty("单店金额")
    private BigDecimal terminalFeeAmount;
    /**
     * 单店金额-字符串，前端用
     */
    @ApiModelProperty("单店金额-字符串，前端用")
    private String terminalFeeAmountStr;

    /**
     * 预估费用 大区策略即为大区承担金额、总部策略就是总部承担金额
     */
    @ApiModelProperty("预估费用 大区策略即为大区承担金额、总部策略就是总部承担金额")
    private BigDecimal feeAmount;
    /**
     * 预估费用 大区策略即为大区承担金额、总部策略就是总部承担金额-字符串，前端用
     */
    @ApiModelProperty("预估费用 大区策略即为大区承担金额、总部策略就是总部承担金额-字符串，前端用")
    private String feeAmountStr;
    /**
     * 总部承担金额
     */
    @ApiModelProperty("总部承担金额")
    private BigDecimal headFeeAmount;
    /**
     * 总部承担金额-字符串，前端用
     */
    @ApiModelProperty("总部承担金额-字符串，前端用")
    private String headFeeAmountStr;
    /**
     * 大区承担金额
     */
    @ApiModelProperty("大区承担金额")
    private BigDecimal departmentFeeAmount;
    /**
     * 已发生大区费用
     */
    @ApiModelProperty("已发生大区费用")
    private BigDecimal usedDepartmentFeeAmount;

    /**
     * 已发生大区费用
     */
    @ApiModelProperty("已发生大区费用")
    private String usedDepartmentFeeAmountStr;
    /**
     * 大区承担金额-字符串，前端用
     */
    @ApiModelProperty("大区承担金额-字符串，前端用")
    private String departmentFeeAmountStr;
    /**
     * 客户承担金额
     */
    @ApiModelProperty("客户承担金额")
    private BigDecimal customerFeeAmount;
    /**
     * 已发生客户费用
     */
    @ApiModelProperty("已发生客户费用")
    private BigDecimal usedCustomerFeeAmount;
    /**
     * 已发生客户费用
     */
    @ApiModelProperty("已发生客户费用")
    private String usedCustomerFeeAmountStr;
    /**
     * 客户承担金额-字符串，前端用
     */
    @ApiModelProperty("客户承担金额-字符串，前端用")
    private String customerFeeAmountStr;
    /**
     * 费用合计
     */
    @ApiModelProperty("费用合计")
    private BigDecimal totalFeeAmount;
    /**
     * 已发生总部费用
     */
    @ApiModelProperty("已发生总部费用")
    private BigDecimal usedHeadFeeAmount;


    /**
     * 已发生总部费用
     */
    @ApiModelProperty("已发生总部费用")
    private String usedHeadFeeAmountStr;
    /**
     * 费用合计-字符串，前端用
     */
    @ApiModelProperty("费用合计-字符串，前端用")
    private String totalFeeAmountStr;
    /**
     * 大区公投预算金额
     */
    @ApiModelProperty("大区公投预算金额（元）")
    private BigDecimal regionReferendumFeeAmount;
    /**
     *大区公投预算金额（元）-字符串，前端用
     */
    @ApiModelProperty("大区公投预算金额（元）-字符串，前端用")
    private String regionReferendumFeeAmountStr;

    /**
     * 大区自投预算金额
     */
    @ApiModelProperty("大区自投预算金额（元）")
    private BigDecimal regionAutomaticFeeAmount;
    /**
     *大区自投预算金额（元）-字符串，前端用
     */
    @ApiModelProperty("大区自投预算金额（元）-字符串，前端用")
    private String regionAutomaticFeeAmountStr;


    /**
     * 扣费细项
     */
    @ApiModelProperty("扣费细项")
    private String deductionDetails;

    @ApiModelProperty("扣费细项名称")
    private String deductionDetailsName;

    /**
     * 已使用金额（元）
     */
    @ApiModelProperty("已使用金额（元）")
    private BigDecimal usedAmount;

    /**
     * 预估费率
     */
    @ApiModelProperty("预估费率")
    private BigDecimal feeRate;
    /**
     * 预估费率-字符串，前端用
     */
    @ApiModelProperty("预估费率-字符串，前端用")
    private String feeRateStr;
    /**
     * 核销条件编码
     */
    @ApiModelProperty("核销条件编码")
    private String auditConditionCode;
    /**
     * 核销条件名称
     */
    @ApiModelProperty("核销条件名称")
    private String auditConditionName;
    /**
     * 促销类型
     */
    @ApiModelProperty("促销类型")
    private String promotionType;
    /**
     * 销售目标
     */
    @ApiModelProperty("销售目标")
    private BigDecimal salesTarget;
    /**
     * 销售目标-字符串，前端用
     */
    @ApiModelProperty("销售目标-字符串，前端用")
    private String salesTargetStr;
    /**
     * 促销政策编码
     */
    @ApiModelProperty("促销政策编码")
    private String promotionCode;
    /**
     * 促销政策名称
     */
    @ApiModelProperty("促销政策名称")
    private String promotionName;
    /**
     * 品牌编码
     */
    @ApiModelProperty("品牌编码")
    private String productBrandCode;
    /**
     * 品牌名称
     */
    @ApiModelProperty("品牌名称")
    private String productBrandName;
    /**
     * 品类编码
     */
    @ApiModelProperty("品类编码")
    private String productCategoryCode;
    /**
     * 品类名称
     */
    @ApiModelProperty("品类名称")
    private String productCategoryName;
    /**
     * 品项编码
     */
    @ApiModelProperty("品项编码")
    private String productItemCode;
    /**
     * 品项名称
     */
    @ApiModelProperty("品项名称")
    private String productItemName;
    /**
     * 考核产品编码
     */
    @ApiModelProperty("考核产品编码")
    private String assessProductCode;
    /**
     * 考核产品名称
     */
    @ApiModelProperty("考核产品名称")
    private String assessProductName;
    /**
     * 产品编码
     */
    @ApiModelProperty("产品编码")
    private String productCode;
    /**
     * 产品名称
     */
    @ApiModelProperty("产品名称")
    private String productName;
    /**
     * 产品单位
     */
    @ApiModelProperty("产品单位")
    private String productUnit;
    /**
     * 产品数量
     */
    @ApiModelProperty("产品数量")
    private Integer productQuantity;
    private String productQuantityStr;
    /**
     * 品项组价格
     */
    @ApiModelProperty("品项组价格")
    private BigDecimal productItemPrice;
    /**
     * 品项组价格-字符串，前端用
     */
    @ApiModelProperty("品项组价格-字符串，前端用")
    private String productItemPriceStr;
    /**
     * 赠品品项编码
     */
    @ApiModelProperty("赠品品项编码")
    private String giftItemCode;
    /**
     * 赠品品项名称
     */
    @ApiModelProperty("赠品品项名称")
    private String giftItemName;
    /**
     * 赠品编码
     */
    @ApiModelProperty("赠品编码")
    private String giftCode;
    /**
     * 赠品名称
     */
    @ApiModelProperty("赠品名称")
    private String giftName;
    /**
     * 赠品单位
     */
    @ApiModelProperty("赠品单位")
    private String giftUnit;
    /**
     * 赠品数量
     */
    @ApiModelProperty("赠品数量")
    private Integer giftQuantity;
    private String giftQuantityStr;
    /**
     * 赠品总量
     */
    @ApiModelProperty("赠品总量")
    private BigDecimal giftWeight;
    /**
     * 赠品总量-字符串，前端用
     */
    @ApiModelProperty("赠品总量-字符串，前端用")
    private String giftWeightStr;
    /**
     * 赠品品项组价格
     */
    @ApiModelProperty("赠品品项组价格")
    private BigDecimal giftItemPrice;
    /**
     * 赠品品项组价格-字符串，前端用
     */
    @ApiModelProperty("赠品品项组价格-字符串，前端用")
    private String giftItemPriceStr;
    /**
     * 品项组特价
     */
    @ApiModelProperty("品项组特价")
    private BigDecimal giftItemSpecialPrice;
    /**
     * 品项组特价-字符串，前端用
     */
    @ApiModelProperty("品项组特价-字符串，前端用")
    private String giftItemSpecialPriceStr;
    /**
     * 结案周期
     */
    @ApiModelProperty("结案周期")
    private String auditCycle;
    /**
     * 结案形式
     */
    @ApiModelProperty("结案形式")
    private String auditForm;
    /**
     * 供应商编码
     */
    @ApiModelProperty("供应商编码")
    private String supplierCode;
    /**
     * 供应商名称
     */
    @ApiModelProperty("供应商名称")
    private String supplierName;
    /**
     * 物料编码
     */
    @ApiModelProperty("物料编码")
    private String materialCode;
    /**
     * 物料名称
     */
    @ApiModelProperty("物料名称")
    private String materialName;
    /**
     * 单价
     */
    @ApiModelProperty("单价")
    private BigDecimal price;
    /**
     * 单价-字符串，前端用
     */
    @ApiModelProperty("单价-字符串，前端用")
    private String priceStr;
    /**
     * 推广场次
     */
    @ApiModelProperty("推广场次")
    private Integer promoteNumber;
    /**
     * 推广场次-字符串，前端用
     */
    @ApiModelProperty("推广场次-字符串，前端用")
    private String promoteNumberStr;
    @ApiModelProperty("费用所属年月")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM")
    @DateTimeFormat(pattern = "yyyy-MM")
    private Date feeYearMonth;

    @DateTimeFormat(pattern = "yyyy-MM")
    private String feeYearMonthStr;

    /**
     * 扣款方式
     */
    @ApiModelProperty("扣款方式/是否扣款，   Y是N否")
    private String deductType;
    /**
     * 是否关闭，   Y是N否
     */
    @ApiModelProperty(name = "isClose", notes = "是否关闭", value = "是否关闭，   Y是N否")
    private String isClose;

    /**
     * 是否选中
     */
    @ApiModelProperty("是否选中 0否1是")
    private String checked;

    /**
     * 已向下规划金额（分子公司活动规划用）
     */
    @ApiModelProperty(value = "已向下规划金额（分子公司活动规划用）", notes = "")
    private BigDecimal downAmount;

    /**
     * 是否完全向下规划（分子公司活动规划用）
     */
    @ApiModelProperty("是否完全向下规划（分子公司活动规划用）")
    private String isAllDown;

    @ApiModelProperty("费用归属年月")
    private String feeBelongYearMonth;

    @ApiModelProperty(value = "业务单元", notes = "")
    private String businessUnitCode;

    @ApiModelProperty("税率")
    private BigDecimal taxRate;
    private String taxRateStr;

    @ApiModelProperty("赠品税率")
    private BigDecimal giftTaxRate;
    private String giftTaxRateStr;

    @ApiModelProperty("系统月计划量")
    private BigDecimal systemMonthPlanQuantity;

    @ApiModelProperty("合同编码")
    private String contractCode;

    @ApiModelProperty("系统承担比例")
    private BigDecimal systemAssumeRatio;

    @ApiModelProperty("我方承担比例")
    private BigDecimal ourAssumeRatio;

    /**
     * 公投可用金额（分子公司预算预测用）
     */
    @ApiModelProperty("公投可用金额（分子公司预算预测用）")
    private BigDecimal publicInputAmount;

    /**
     * 公投可用金额字符串（分子公司预算预测用）
     */
    @ApiModelProperty("公投可用金额字符串（分子公司预算预测用）")
    private String publicInputAmountStr;

    @ApiModelProperty("浮动率")
    private BigDecimal floatingRate;
    private String floatingRateStr;

    /**
     * 区域
     */
    @ApiModelProperty("区域")
    private String region;
    /**
     * 城市名称
     */
    @ApiModelProperty("城市名称")
    private String cityName;

    /**
     * 客户编码
     */
    @ApiModelProperty("客户编码")
    private String customerCode;
    /**
     * 客户编码
     */
    @ApiModelProperty("客户ERP编码")
    private String customerErpCode;
    /**
     * 客户名称
     */
    @ApiModelProperty("客户名称")
    private String customerName;

    @CrmExcelColumn(value = "客户组编码")
    private String customerGroupCode;
    @CrmExcelColumn(value = "客户组名称")
    private String customerGroupName;

    @ApiModelProperty("是否扣减费用池")
    private String isDeductionFeePool;

    @ApiModelProperty(name = "扣费类型", notes = "扣费类型")
    private String feeType;

    @ApiModelProperty(name = "扣费标准", notes = "扣费标准")
    private String feeStandard;

    @ApiModelProperty("核销方式")
    private String writeOffMethod;

    /**
     * 本品生产日期
     */
    @ApiModelProperty("本品生产日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date thisProductProductionDate;
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private String thisProductProductionDateStr;
    /**
     * 赠品生产日期
     */
    @ApiModelProperty("赠品生产日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date giftProductionDate;
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private String giftProductionDateStr;

    @ApiModelProperty("活动号")
    private String  activityNumber;

    /**
     * AC分仓编码
     */
    @ApiModelProperty("AC分仓编码")
    private String acWarehouseCode;

    /**
     * AC门店类型
     */
    @ApiModelProperty("AC门店类型")
    private String acStoreType;

    /**
     * 原供价（本品）
     */
    @ApiModelProperty("原供价（本品）")
    private BigDecimal originalSupplyPrice;
    private String originalSupplyPriceStr;
    /**
     * 原未税价格（本品）
     */
    @ApiModelProperty("原未税价格（本品）")
    private BigDecimal originalPriceProduct;
    private String originalPriceProductStr;

    /**
     * 原供价（赠品）
     */
    @ApiModelProperty( "原供价（赠品）")
    private BigDecimal originalPriceGift;
    private String originalPriceGiftStr;
    /**
     * 原未税价格（赠品）
     */
    @ApiModelProperty("原未税价格（赠品）")
    private BigDecimal originalTaxPriceGift;
    private String originalTaxPriceGiftStr;

    /**
     * 促销含税供价
     */
    @ApiModelProperty("促销含税供价")
    private BigDecimal promotionPriceTax;
    private String promotionPriceTaxStr;
    /**
     * 促销未税供价
     */
    @ApiModelProperty("促销未税供价")
    private BigDecimal promotionNonTaxPrice;
    private String promotionNonTaxPriceStr;
    /**
     * 零售价
     */
    @ApiModelProperty("零售价")
    private BigDecimal retailPrice;
    private String retailPriceStr;
    /**
     * 促销售价
     */
    @ApiModelProperty("促销售价")
    private BigDecimal promotionalPrice;
    private String promotionalPriceStr;


    /**
     * 原毛利率
     */
    @ApiModelProperty("原毛利率")
    private BigDecimal originalGrossRate;
    private String originalGrossRateStr;
    /**
     * 促销毛利率
     */
    @ApiModelProperty("促销毛利率")
    private BigDecimal promotionalGrossRate;
    private String promotionalGrossRateStr;

    /**
     * 单件申请费用
     */
    @ApiModelProperty("单件申请费用")
    private BigDecimal singleApplicationFee;
    private String singleApplicationFeeStr;
    /**
     * 期间促销件数
     */
    @ApiModelProperty("期间促销件数")
    private Integer periodPromotionalNumber;
    private String periodPromotionalNumberStr;

    @ApiModelProperty("门店编码")
    private String terminalCode;

    @ApiModelProperty("门店名称")
    private String terminalName;

    /**
     * 方案模板名称
     */
    @ApiModelProperty("方案模板名称")
    private String templateConfigName;


    /**
     * 期间促销金额
     */
    @ApiModelProperty("期间促销金额")
    private BigDecimal periodPromotionalAmount;
    private String periodPromotionalAmountStr;
    /**
     * 系统承担金额
     */
    @ApiModelProperty("系统承担金额")
    private BigDecimal systemBorneAmount;
    private String systemBorneAmountStr;

    @ApiModelProperty("城市等级")
    private String cityLevel;

    /**
     * 是否公用
     */
    @ApiModelProperty("是否公用")
    private String publicOrNot;

    /**
     * 门店公用量
     */
    @ApiModelProperty("门店公用量")
    private Integer storeUtility;
    private String storeUtilityStr;
    /**
     * 门店公用金额
     */
    @ApiModelProperty("门店公用金额")
    private BigDecimal storePublicAmount;
    private String storePublicAmountStr;
    /**
     * 浮动量
     */
    @ApiModelProperty("浮动量")
    private BigDecimal floatingNumber;
    private String floatingNumberStr;
    /**
     * 浮动金额
     */
    @ApiModelProperty("浮动金额")
    private BigDecimal floatingAmount;
    private String floatingAmountStr;
    /**
     * 活动描述
     */
    @ApiModelProperty("活动描述")
    private String activityDesc;
    /**
     * 档期开始日期（字符）
     */
    @ApiModelProperty("档期开始日期（字符）")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private String scheduleBeginDateStr;
    /**
     * 档期开始日期
     */
    @ApiModelProperty("档期开始日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date scheduleBeginDate;
    /**
     * 档期结束日期（字符）
     */
    @ApiModelProperty("档期结束日期（字符）")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private String scheduleEndDateStr;
    /**
     * 档期结束日期
     */
    @ApiModelProperty("档期结束日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date scheduleEndDate;
    /**
     * 档期名称
     */
    @ApiModelProperty("档期名称")
    private String scheduleName;
    /**
     * 核销类型
     */
    @ApiModelProperty("核销类型")
    private String auditType;

    @ApiModelProperty("未含税单价")
    private BigDecimal priceExcludingTax;
    private String priceExcludingTaxStr;

    @ApiModelProperty("含税单价")
    private BigDecimal priceIncludingTax;
    private String priceIncludingTaxStr;

    @ApiModelProperty("未含税金额")
    private BigDecimal amountExcludingTax;
    private String amountExcludingTaxStr;

    @ApiModelProperty("含税金额")
    private BigDecimal amountIncludingTax;
    private String amountIncludingTaxStr;

    @ApiModelProperty("采购类型")
    private String isTypeOfPurchaseNo;

    @ApiModelProperty("投产比")
    private BigDecimal productionRatio;
    private String productionRatioStr;

    @ApiModelProperty("购买方式(陈列方案前端用)")
    private String buyWay;

    @ApiModelProperty("是否档期(陈列方案前端用)")
    private String onScheduleOrNot;

    @ApiModelProperty("月度计划量(陈列方案前端用)")
    private String monthlyPlannedQuantityStr;
    private BigDecimal monthlyPlannedQuantity;

    /**
     * 申请金额
     */
    @ApiModelProperty("申请金额")
    private String applyAmountStr;
    private BigDecimal applyAmount;
    /**
     * 核销条件编码
     */
    @ApiModelProperty("手续费点数")
    private String commissionPointStr;
    private BigDecimal commissionPoint;
    /**
     * 核销条件编码
     */
    @ApiModelProperty("手续费金额")
    private String commissionAmountStr;
    private BigDecimal commissionAmount;

    @ApiModelProperty("陈列数量")
    private BigDecimal displayQuantity;
    private String displayQuantityStr;

    /**
     * 所属销售机构编码
     */
    @ApiModelProperty("所属销售机构编码")
    private String salesInstitutionCode;

    /**
     * 所属销售机构编码
     */
    @ApiModelProperty("所属销售机构编码")
    private String salesInstitutionErpCode;


    /**
     * 所属销售机构
     */
    @ApiModelProperty("所属销售机构")
    private String salesInstitutionName;

    @ApiModelProperty("所属销售大区编码")
    private String salesRegionErpCode;

    @ApiModelProperty("所属销售大区编码")
    private String salesRegionCode;

    @ApiModelProperty("所属销售大区编码")
    private String salesRegionName;

    @ApiModelProperty("所属销售组织(组)编码")
    private String salesOrgErpCode;

    @ApiModelProperty("所属销售组织(组)编码")
    private String salesOrgCode;


    @ApiModelProperty("所属销售组织(组)名称")
    private String salesOrgName;

    @ApiModelProperty("员工id(人员方案模板用)")
    private String employeeId;

    @ApiModelProperty("导购员姓名")
    private String nameOfShoppingGuide;

    @ApiModelProperty("全品活动期间销售目标（元）")
    private BigDecimal activitySaleTargetAmount;
    private String activitySaleTargetAmountStr;

    @ApiModelProperty(value = "物料数量")
    private BigDecimal materialQuantity;
    private String materialQuantityStr;

    @ApiModelProperty("活动场次")
    private String activityEventCode;

    @ApiModelProperty("场次名称")
    private String activityEventName;

    @ApiModelProperty("合同未税金额")
    private BigDecimal contractExcludingTax;
    private String contractExcludingTaxStr;

    @ApiModelProperty("合同含税金额")
    private BigDecimal contractIncludingTax;
    private String contractIncludingTaxStr;

    @ApiModelProperty("随车搭赠组合")
    private String carGiftGroup;

    @ApiModelProperty("面值")
    private BigDecimal faceValue;
    private String faceValueStr;

    @ApiModelProperty("个税金额（元）")
    private BigDecimal personalIncomeTax;
    private String personalIncomeTaxStr;
    /**
     * 年月
     */
    @ApiModelProperty("年月")
    private String yearMonthLy;

    /**
     * 是否破价
     */
    private String isBreakPrice;

    /**
     * 是否回退预算： Y是N否
     */
    @ApiModelProperty(name = "isRollbackBudget", notes = "是否已回退预算", value = "是否回退预算： Y是N否")
    private String isRollbackBudget;

    @ApiModelProperty("搭赠类型")
    private String bonusType;





    /**
     * 政策支持
     */
    @ApiModelProperty("政策支持")
    private String promotionSupport;
    /**
     * 活动方案明细编码
     */
    @ApiModelProperty("组合品编码")
    private String productCode2;
    /**
     * 组合品名称
     */
    @ApiModelProperty("组合品名称")
    private String productName2;

    @ApiModelProperty("是否承接总部方案力度")
    private String isUndertakingIntensity;

    /**
     * 关联总部策略编码
     */
    @ApiModelProperty("关联总部策略编码")
    private String relateHeadStrategyCode;

    /**
     * 关联总部策略明细编码
     */
    @ApiModelProperty("关联总部策略明细编码")
    private String relateHeadStrategyItemCode;
    /**
     * 是否大日期
     */
    @ApiModelProperty("是否大日期")
    private String isBigDate;

    /**
     * 大日期盘点数量
     */
    @ApiModelProperty("大日期盘点数量")
    private BigDecimal bigDateQty;

    /**
     * 员工号
     */
    @ApiModelProperty(name = "employeeCode", notes = "员工号")
    private String employeeCode;

    /**
     * 集群/职能
     * */
    @ApiModelProperty("集群/职能")
    private String functioned;

    /**
     * 系统主管
     * */
    @ApiModelProperty("系统主管")
    private String systemSupervisor;

    /**
     * 省份
     * */
    @ApiModelProperty("省份")
    private String province;

    /**
     * 联系方式
     * */
    @ApiModelProperty("联系方式")
    private String contactInformation;

    /**
     * 卡片类型
     * */
    @ApiModelProperty("卡片类型")
    private String cardType;

    /**
     * 卡内提数
     * */
    @ApiModelProperty("卡内提数")
    private Integer carnegieNumber;

    /**
     * 姓名
     * */
    @ApiModelProperty("姓名")
    private String milkName;

    /**
     * 职位
     * */
    @ApiModelProperty("职位")
    private String position;

    /**
     * 电话
     * */
    @ApiModelProperty("电话")
    private String telephone;

    /**
     * 大日期来源
     */
    @ApiModelProperty("大日期来源")
    private String bigDateSource;

    /**
     * GMV（元）
     */
    @ApiModelProperty("GMV（元）")
    private BigDecimal gmv;

    private String gmvStr;

    /**
     * 平台
     */
    @ApiModelProperty("平台")
    private String platform;

    @ApiModelProperty("推送sap状态标记")
    private String sapInterfaceState;

    /**
     * 零售商渠道
     */
    @ApiModelProperty("零售商渠道")
    private String retailerChannel;
    /**
     * 库存可用数量
     */
    @ApiModelProperty(name = "inventoryCheckUsableQuantity", notes = "库存可用数量")
    private Integer inventoryCheckUsableQuantity;


    /**
     * 调整前版本号
     */
    @ApiModelProperty("调整前变更编码")
    private String currModifyBusinessCode;

}
