package com.biz.crm.tpm.business.activity.plan.sdk.pojo;


import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 活动方案表-大区关联总部方案(ActivityPlanRelatePlan)
 *
 * @author wanghaojia
 * @since 2022-10-31 15:55:57
 */
@Getter
@Setter
public class ActivityPlanRelatePlanBase {

    @ApiModelProperty(name = "id", value = "主键ID")
    private String id;
    @ApiModelProperty(name = "createAccount", value = "创建人账号")
    private String createAccount;
    @ApiModelProperty(name = "createTime", value = "创建时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;
    @ApiModelProperty(name = "createName", value = "创建人名称")
    private String createName;
    @ApiModelProperty(name = "modifyAccount", value = "更新人账号")
    private String modifyAccount;
    @ApiModelProperty(name = "modifyTime", value = "最后更新时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date modifyTime;
    @ApiModelProperty(name = "modifyName", value = "修改人名称")
    private String modifyName;
    @ApiModelProperty(name = "delFlag", value = "删除状态，003已删除，009未删除")
    private String delFlag;
    @ApiModelProperty(name = "enableStatus", value = "启禁用状态，003禁用，009启用")
    private String enableStatus;
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;
    @ApiModelProperty(name = "tenantCode", value = "租户编号")
    private String tenantCode;



    /**
     * 方案编码
     */
    @ApiModelProperty("方案编码")
    private String planCode;

    /**
     * 关联方案编码
     */
    @ApiModelProperty("关联方案编码")
    private String relatePlanCode;
    /**
     * 关联方案名称
     */
    @ApiModelProperty("关联方案名称")
    private String relatePlanName;
    /**
     * 关联方案范围
     */
    @ApiModelProperty("关联方案范围")
    private String relateOrgName;

    /**
     * 方案开始时间
     */
    @ApiModelProperty("关联方案开始时间")
    private String relatePlanBeginDate;
    /**
     * 关联方案结束时间
     */
    @ApiModelProperty("关联方案结束时间")
    private String relatePlanEndDate;

    /**
     * 关联方案费用（元）
     */
    @ApiModelProperty("关联方案费用（元）")
    private BigDecimal relatePlanTotalFeeAmount;

    /**
     * 方案已申请金额
     */
    @ApiModelProperty("方案已申请金额")
    private BigDecimal usedAmount;

    /**
     * 方案已申请金额
     */
    @ApiModelProperty("方案剩余可用方案金额")
    private BigDecimal usableAmount;

    /**
     * 本次使用方案金额
     */
    @ApiModelProperty("本次使用方案金额")
    private BigDecimal useAmount;

}

