package com.biz.crm.tpm.business.activity.plan.sdk.pojo;


import com.biz.crm.tpm.business.marketing.strategy.sdk.pojo.MarketingStrategyItemBase;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 活动方案-策略表(ActivityPlanStrategy)
 *
 * @author wanghaojia
 * @since 2022-11-01 14:39:19
 */
@ApiModel(value = "ActivityPlanStrategyBase", description = "活动方案-策略表Base")
@Getter
@Setter
public class ActivityPlanStrategyBase extends MarketingStrategyItemBase {

    @ApiModelProperty(name = "id", value = "主键ID")
    private String id;
    @ApiModelProperty(name = "createAccount", value = "创建人账号")
    private String createAccount;
    @ApiModelProperty(name = "createTime", value = "创建时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;
    @ApiModelProperty(name = "createName", value = "创建人名称")
    private String createName;
    @ApiModelProperty(name = "modifyAccount", value = "更新人账号")
    private String modifyAccount;
    @ApiModelProperty(name = "modifyTime", value = "最后更新时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date modifyTime;
    @ApiModelProperty(name = "modifyName", value = "修改人名称")
    private String modifyName;
    @ApiModelProperty(name = "delFlag", value = "删除状态，003已删除，009未删除")
    private String delFlag;
    @ApiModelProperty(name = "enableStatus", value = "启禁用状态，003禁用，009启用")
    private String enableStatus;
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;
    @ApiModelProperty(name = "tenantCode", value = "租户编号")
    private String tenantCode;


    /**
     * 活动方案编码
     */
    @ApiModelProperty("活动方案编码")
    private String planCode;

    /**
     * 营销策略编码
     */
    @ApiModelProperty("营销策略编码")
    private String strategyCode;
    /**
     * 营销策略编码
     */
    @ApiModelProperty("营销策略编码")
    private String strategyItemCode;
    /**
     * 营销策略名称
     */
    @ApiModelProperty("营销策略名称")
    private String strategyName;
    /**
     * 营销策略名称
     */
    @ApiModelProperty("营销策略类型")
    private String strategyType;

    /**
     * 费用金额（元）
     */
    @ApiModelProperty("费用金额（元）")
    private BigDecimal feeAmount;


    @ApiModelProperty("已申请金额")
    private BigDecimal usedAmount;


    @ApiModelProperty("剩余可用策略金额")
    private BigDecimal usableAmount;


    @ApiModelProperty("本次使用策略金额")
    private BigDecimal useAmount;

    @ApiModelProperty("关联策略总金额（元）")
    private BigDecimal strategyFeeAmount;


    @ApiModelProperty("关联策略已申请总金额（元）")
    private BigDecimal strategyUsedAmount;


    @ApiModelProperty("关联策略剩余可申请总金额（元）")
    private BigDecimal strategyUsableAmount;

}

