package com.biz.crm.tpm.business.activity.plan.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanBudgetDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanDto;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanBudgetVo;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanVo;
import com.biz.crm.tpm.business.month.budget.sdk.dto.OperateMonthBudgetDto;
import org.springframework.data.domain.Pageable;

import java.util.List;
import java.util.Set;

/**
 * 活动方案外部接口
 * @author wanghaojia
 * @date 2022/11/25 10:23
 */
public interface ActivityPlanBudgetSdkService {

    List<ActivityPlanBudgetDto> listDtoByPlanCodeList(List<String> planCodeList);

    /**
     * 根据方案明细编码查预算信息
     *
     * @param codeSet
     * @return
     */
    List<ActivityPlanBudgetVo> findByPlanItemCode(Set<String> codeSet);

    /**
     * 根据方案编码查预算信息
     *
     * @param planSet
     * @return
     */
    List<ActivityPlanBudgetVo> findByPlanCode(Set<String> planSet);

    /**
     * 查询活动细案关联的活动方案中，是关联了总部方案的大区活动方案编码。
     * @param planCodes
     * @return
     */
    List<ActivityPlanBudgetVo> findRegionIsRelateHead(List<String> planCodes);
}
