package com.biz.crm.tpm.business.activity.plan.sdk.service;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanBudgetDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanItemBudgetDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanItemDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.RedPacketQueryScheme2Dto;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanBudgetVo;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanItemBudgetVo;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanItemVo;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.RedPacketQueryScheme2Vo;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 活动方案明细表(ActivityPlanItem)表服务接口
 *
 * @author wanghaojia
 * @since 2022-11-01 15:11:38
 */
public interface ActivityPlanItemSdkService {

    /**
     * 分页查询所有数据
     *
     * @param pageable
     * @param activityPlanItemDto
     * @return com.baomidou.mybatisplus.extension.plugins.pagination.Page<com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanItemVo>
     * @author huojia
     * @date 2022/12/9 16:52
     **/
    Page<ActivityPlanItemVo> findByConditions(Pageable pageable, ActivityPlanItemDto activityPlanItemDto);

    List<ActivityPlanItemBudgetVo> findItemBudgetListByConditions(ActivityPlanItemBudgetDto activityPlanItemBudgetDto);

    /**
     * 根据明细编码查询明细
     *
     * @param itemCodeList
     * @return java.util.List<com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanItemVo>
     * @author huojia
     * @date 2022/11/27 19:09
     **/
    List<ActivityPlanItemVo> listByItemCodeList(List<String> itemCodeList);

    /**
     * 更新向下规划金额
     *
     * @param operationBudgetList
     * @author huojia
     * @date 2022/11/30 20:42
     **/
    void operationBudget(List<ActivityPlanBudgetDto> operationBudgetList);

    List<RedPacketQueryScheme2Vo> redPacketQueryScheme(RedPacketQueryScheme2Dto dto);

    /**
     * 根据活动号判断同一活动号下面的方案是否都已关闭
     *
     * @param actNo 活动号
     * @return Boolean
     **/
    Boolean getAllColseByActNumber(String actNo);

    /**
     * 条件查询总条数
     *
     * @param activityPlanItemDto
     * @return
     */
    Integer findTotalByConditions(ActivityPlanItemDto activityPlanItemDto);

    /**
     * 总部方案明细找到对应的大区方案明细
     * @param planItemCode
     * @return
     */
    List<ActivityPlanItemVo> findByHeadquartersPlanItemCode(String planItemCode);

    /**
     * 根据方案编码查询方案明细
     * @param planItemCode
     * @return
     */
    ActivityPlanItemVo findListByPlanItemCode(String planItemCode);

    /**
     * 根据关联方案明细编码查询方案明细编码
     */
    List<String> findItemCodeListByRelatePlanItemCodeList(List<String> planItemCodeList);

    List<ActivityPlanBudgetVo> findItemBudgetListByPlanCode(String planCode);

    /**
     * 更改方案明细的核销状态
     * @param auditPlanItemCodes
     */
    void updateAuditStatusByCodes(List<String> auditPlanItemCodes);

    List<ActivityPlanBudgetVo> findItemBudgetListByPlanItemCode(String planItemCode);

    void updateWholeAuditByPlanItemCode(String businessCode);

    /**
     * 事中费用申请：报表年月的活动，“核销方式”为“事中”，“结案形式”为“随单”TPM审批状态为“审批通过”的方案明细费用合计
     * @param activityPlanItemDtos
     * @return
     */
    List<ActivityPlanItemVo> findListForFR(List<ActivityPlanItemDto> activityPlanItemDtos);

    List<ActivityPlanItemVo> findCostListForFR(List<ActivityPlanItemDto> itemDtos, String code);

    List<ActivityPlanItemVo> findRelatedPlanItemByCodes(List<String> relatePlanItemCodes);
    /**
     * 方案明细更新已结案金额
     * @param activityPlanItemDtoList
     */
    void updateAlreadyAuditAmount(List<ActivityPlanItemDto> activityPlanItemDtoList);
}

