package com.biz.crm.tpm.business.activity.plan.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanItemDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanOutDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.OperateActivityPlanBudgetDto;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanBudgetVo;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanRelatePlanVo;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanStrategyVo;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanVo;
import org.springframework.data.domain.Pageable;

import java.util.List;
import java.util.Set;

/**
 * 活动方案外部接口
 * @author wanghaojia
 * @date 2022/11/25 10:23
 */
public interface ActivityPlanSdkService {

    /**
     * 分页查询所有数据
     *
     * @param pageable 分页对象
     * @param dto 查询实体
     * @return 所有数据
     */
    Page<ActivityPlanVo> findByConditions(Pageable pageable, ActivityPlanDto dto);

    /**
     * 占用方案预算
     */
    void operateBudget(List<OperateActivityPlanBudgetDto> planBudgetOperateList);

    /**
     * 占用方案上的客户预算
     */
    void operateCustomerBudget(List<OperateActivityPlanBudgetDto> planBudgetOperateList);

    /**
     * 更据方案编码查询详情
     * @param planCodes 方案编码集合
     */
    List<ActivityPlanVo> findByCodes(Set<String> planCodes);

    /**
     * 根据方案编码查询详情
     * @param planCodes 方案编码集合
     */
    List<ActivityPlanVo> findByPlanCodeList(Set<String> planCodes);

    String findPlanCodeByPlanName(String planName);

    /**
     * 构建方案参数
     * @param businessNoList
     * @return
     */
    List<ActivityPlanDto> buildActivityPlanParms(List<String> businessNoList);

    /**
     * 根据方案编码集合查询方案数据
     * @param planCodeList 方案编码集合
     */
    List<ActivityPlanDto> findPlanDtoListByCodeList(List<String> planCodeList);

    /**
     * 根据方案编码集合查询关联方案明细及其他数据
     * @param planCodeList 方案编码集合
     */
    List<ActivityPlanItemDto> findItemDtoAndAttachListByPlanCodeList(List<String> planCodeList);

    List<ActivityPlanVo> findPlanActivityEndTime(Set<String> activityDetailCodes);

    List<ActivityPlanItemDto> findByPlanItem(String planCode);

    /**
     * 大区方案关联的总部方案
     * @param planCode
     * @return
     */
    List<ActivityPlanRelatePlanVo> findRelatePLan(String planCode);

    /**
     * 方案关联的策略数据
     * @param planCodeList 方案编码集合
     */
    List<ActivityPlanStrategyVo> findActivityPlanStrategyVoList(List<String> planCodeList);

    void createActivityPlan(ActivityPlanDto planDto);

    ActivityPlanVo findByPlanItemCode(String planItemCode);

    ActivityPlanVo findById(String id);

    ActivityPlanOutDto createForOut(ActivityPlanOutDto dto);

    ActivityPlanOutDto updateForOut(ActivityPlanOutDto dto);

    void delete(List<String> ids);

    Object atomCreate(ActivityPlanOutDto dto);

    /**
     * 主体方案预测活动结束时间延期
     * @param list
     */
    void updateActivityDelayEndTime(List<ActivityPlanItemDto> list);

    /**
     * 大区方案编码查询关联总部方案编码和总部策略编码
     * @param planCodes
     * @return
     */
    List<ActivityPlanBudgetVo> findHeadquartersByRegionPlanCodes(Set<String> planCodes);


    List<ActivityPlanVo> findActivityUsableBudget(List<String> planCodeList);


    List<ActivityPlanVo> findOrgCodeByPlanCode(List<String> planCodes);
}
