package com.biz.crm.tpm.business.activity.plan.sdk.service;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.sfa.SfaActivityPlanCreateResult;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.sfa.SfaActivityPlanItemStatusUpdateDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.sfa.display.SfaActivityPlanDisplayCreateDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.sfa.person.SfaActivityPlanPersonCreateDto;

import java.util.List;

/**
 * SFA推送数据到TPM接口
 * @author wanghaojia
 * @date 2023/1/5 15:20
 */
public interface SfaPushActivityPlanService {

    /**
     * 人员费用创建接口
     * @param list 活动数据
     * @return 活动方案编号
     */
    Result<List<SfaActivityPlanCreateResult>> sfaActivityPlanCreatePerson(List<SfaActivityPlanPersonCreateDto> list);

    /**
     * 陈列费用创建接口
     * @param list 活动数据
     * @return 活动方案编号
     */
    Result sfaActivityPlanCreateDisplay(List<SfaActivityPlanDisplayCreateDto> list);

    /**
     * 更新活动占用状态
     * @param updateList 要更新的数据
     */
    Result updateSfaActivityPlanState(List<SfaActivityPlanItemStatusUpdateDto> updateList);

}
