package com.biz.crm.tpm.business.activity.plan.sdk.vo;


import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import java.math.BigDecimal;

/**
 * 活动方案预算表(ActivityPlanBudgetVo)
 *
 * @author wanghaojia
 * @since 2022-11-01 14:39:19
 */
@ApiModel(value = "ActivityPlanBudgetVo", description = "活动方案预算表")
@Getter
@Setter
public class ActivityPlanBudgetVo extends TenantFlagOpEntity {

    /**
     * 活动方案编码
     */
    @ApiModelProperty("活动方案编码")
    private String planCode;
    @ApiModelProperty("活动方案名称")
    private String planName;
    /**
     * 活动方案明细编码
     */
    @ApiModelProperty("活动方案明细编码")
    private String planItemCode;

    /**
     * 占用类型，1-占用月度预算，2-占用方案预算
     */
    @ApiModelProperty(value = "占用类型", notes = "")
    @Column(name = "occupy_type", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '占用类型'")
    private String occupyType;
    /**
     * 关联策略编码
     */
    @ApiModelProperty("关联策略编码")
    @Column(name = "relate_strategy_code", length = 32, columnDefinition = "varchar(32) COMMENT '关联策略编码'")
    private String relateStrategyCode;

    @ApiModelProperty("关联策略名称")
    private String relateStrategyName;
    /**
     * 关联策略明细编码
     */
    @ApiModelProperty("关联策略明细编码")
    @Column(name = "relate_strategy_item_code", length = 32, columnDefinition = "varchar(32) COMMENT '关联策略明细编码'")
    private String relateStrategyItemCode;
    /**
     * 上级方案编码
     */
    @ApiModelProperty("上级方案编码")
    @Column(name = "relate_plan_code", length = 32, columnDefinition = "varchar(32) COMMENT '上级方案编码'")
    private String relatePlanCode;

    @ApiModelProperty("上级方案名称")
    private String relatePlanName;
    /**
     * 上级方案明细编码
     */
    @ApiModelProperty("上级方案明细编码")
    @Column(name = "relate_plan_item_code", length = 32, columnDefinition = "varchar(32) COMMENT '上级方案明细编码'")
    private String relatePlanItemCode;

    /**
     * 关联方案预测明细编码（垂直）
     */
    @ApiModelProperty("关联方案预测明细编码")
    @Column(name = "scheme_forecast_detail_code", length = 32, columnDefinition = "varchar(32) COMMENT '关联方案预测明细编码'")
    private String schemeForecastDetailCode;

    /**
     * 月度预算编码
     */
    @ApiModelProperty(value = "月度预算编码", notes = "")
    private String monthBudgetCode;

    /**
     * 预算项目编码
     */
    @ApiModelProperty(value = "预算项目编码", notes = "")
    private String budgetItemCode;

    /**
     * 预算项目名称
     */
    @ApiModelProperty(value = "预算项目名称", notes = "")
    private String budgetItemName;

    /**
     * 费用归口[数据字典:tpm_fee_belong]
     */
    @ApiModelProperty(value = "费用归口[数据字典:tpm_fee_belong]", notes = "")
    private String feeBelongCode;

    private String feeSourceName;

    /**
     * 年月
     */
    @ApiModelProperty(value = "年月", notes = "")
    private String yearMonthLy;

    /**
     * 产品编码
     */
    @ApiModelProperty(value = "产品编码", notes = "")
    private String productCode;

    /**
     * 产品名称
     */
    @ApiModelProperty(value = "产品名称", notes = "")
    private String productName;

    /**
     * 组织编码
     */
    @ApiModelProperty(value = "组织编码", notes = "")
    private String orgCode;

    /**
     * 组织名称
     */
    @ApiModelProperty(value = "组织名称", notes = "")
    private String orgName;


    /**
     * 累计可用余额
     */
    @ApiModelProperty(value = "累计可用余额", notes = "")
    private BigDecimal accumulatedAvailableBalance;

    /**
     * 使用金额
     */
    @ApiModelProperty(value = "使用金额", notes = "")
    private BigDecimal useAmount;
    private String useAmountStr;

    /**
     * 已使用金额
     */
    @ApiModelProperty(value = "已使用金额", notes = "")
    private BigDecimal usedAmount;

    /**
     * 剩余可用金额
     */
    @ApiModelProperty(value = "剩余可用金额", notes = "")
    private BigDecimal usableAmount;
    /**
     * 回退预算金额
     */
    @ApiModelProperty(value = "回退预算金额", notes = "")
    private BigDecimal returnAmount;

    /**
     * 使用优先级
     */
    @ApiModelProperty(value = "使用优先级", notes = "")
    private Integer usePriority;
    private String usePriorityStr;

    /**
     * 使用比例
     */
    @ApiModelProperty(value = "使用比例", notes = "")
    private BigDecimal useRatio;
    private String useRatioStr;

    /**
     * 已向下规划金额（分子公司活动规划用）
     */
    @ApiModelProperty(value = "已向下规划金额（分子公司活动规划用）", notes = "")
    private BigDecimal downAmount;

    /**
     * 是否完全向下规划（分子公司活动规划用）
     */
    @ApiModelProperty("是否完全向下规划（分子公司活动规划用）")
    private String isAllDown;

    @ApiModelProperty("区域")
    private String region;

    /**
     * 区域编码
     */
    @ApiModelProperty("区域编码")
    private String activityOrgCode;
    /**
     * 区域名称
     */
    @ApiModelProperty("区域名称")
    private String activityOrgName;
}

