package com.biz.crm.tpm.business.activity.plan.sdk.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author wanghaojia
 * @date 2023/2/18 07:50
 */
@Data
@ApiModel("活动方案明细预算信息VO")
public class ActivityPlanItemBudgetVo {

    @ApiModelProperty("方案编码")
    private String planCode;

    @ApiModelProperty("方案名称")
    private String planName;

    @ApiModelProperty("方案类型")
    private String planType;

    @ApiModelProperty("方案明细编码")
    private String planItemCode;

    @ApiModelProperty("总部统筹预算编码")
    private String headMonthBudgetCode;

    @ApiModelProperty("总部统筹预算项目编码")
    private String headBudgetItemCode;

    @ApiModelProperty("总部统筹预算项目名称")
    private String headBudgetItemName;

    @ApiModelProperty("总部统筹预算名称")
    private String headMonthBudgetName;

    @ApiModelProperty("大区预算项目编码")
    private String monthBudgetCode;

    @ApiModelProperty("大区预算项目名称")
    private String budgetItemCode;

    @ApiModelProperty("大区预算名称")
    private String budgetItemName;

    @ApiModelProperty("方案申请金额")
    private BigDecimal totalFeeAmount;

    @ApiModelProperty("总部承担金额")
    private BigDecimal headFeeAmount;

    @ApiModelProperty("总部承担金额")
    private BigDecimal departmentFeeAmount;

    @ApiModelProperty("客户承担金额")
    private BigDecimal customerFeeAmount;

    @ApiModelProperty("已使用总金额")
    private BigDecimal usedAmount;

    @ApiModelProperty("已使用总部承担金额")
    private BigDecimal headUsedAmount;

    @ApiModelProperty("已使用大区承担金额")
    private BigDecimal departmentUsedAmount;

    @ApiModelProperty("已使用客户承担金额")
    private BigDecimal customerUsedAmount;

    /**
     * 部门编码
     */
    @ApiModelProperty("部门编码")
    private String departmentCode;

    /**
     * 部门名称
     */
    @ApiModelProperty("部门名称")
    private String departmentName;

    @ApiModelProperty("剩余可使用总金额")
    private BigDecimal usableAmount;

    @ApiModelProperty("剩余总部承担金额")
    private BigDecimal headUsableAmount;

    @ApiModelProperty("剩余大区承担金额")
    private BigDecimal departmentUsableAmount;

    @ApiModelProperty("剩余客户承担金额")
    private BigDecimal customerUsableAmount;

    /**
     * 冗余，前端使用
     */
    @ApiModelProperty("是否完全承接")
    private String fullAccept;

}
