package com.biz.crm.tpm.business.activity.plan.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author ：dengwei
 * @date ：Created in 2023/1/12 10:41
 * @description：方案门店明细
 */
@ApiModel(value = "ActivityPlanItemTerminalVo", description = "方案门店明细")
@Getter
@Setter
public class ActivityPlanItemTerminalVo extends TenantFlagOpVo {
    /**
     * 活动方案编码
     */
    @ApiModelProperty("活动方案编码")
    private String planCode;
    /**
     * 活动方案明细编码
     */
    @ApiModelProperty("活动方案明细编码")
    private String planItemCode;


    /**
     * 门店编码
     */
    @ApiModelProperty(name = "门店编码", notes = "门店编码")
    private String terminalCode;

    /**
     * 门店名称
     */
    @ApiModelProperty(name = "门店名称", notes = "门店名称")
    private String terminalName;

    @ApiModelProperty(name = "responsibleBusiness", notes = "责任业务")
    private String responsibleBusiness;

    @ApiModelProperty(name = "responsibleSupervision", notes = "责任督导")
    private String responsibleSupervision;

    @ApiModelProperty(name = "name", notes = "用户姓名")
    private String name;

    @ApiModelProperty(name = "empId", notes = "empId")
    private String empId;

    @ApiModelProperty(name = "employeeCode", notes = "员工号")
    private String employeeCode;

    @ApiModelProperty(name = "employeeCode", notes = "员工号")
    private Date beginDate;

    @ApiModelProperty(name = "employeeCode", notes = "员工号")
    private Date endDate;

    @ApiModelProperty(name = "phone", notes = "手机号")
    private String phone;

    @ApiModelProperty(name = "identityCard", notes = "身份证号")
    private String identityCard;

    @ApiModelProperty("标准")
    private BigDecimal standard;

    @ApiModelProperty("数量")
    private BigDecimal quantity;

    @ApiModelProperty("金额")
    private BigDecimal amount;

    @ApiModelProperty("我方承担金额")
    private BigDecimal feeAmount;

    @ApiModelProperty("系统承担金额")
    private BigDecimal systemBorneAmount;

    @ApiModelProperty("浮动率")
    private BigDecimal floatingRate;
    private String floatingRateStr;
}
