package com.biz.crm.tpm.business.activity.plan.sdk.vo;


import com.biz.crm.tpm.business.activity.plan.sdk.pojo.ActivityPlanItemBase;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import java.math.BigDecimal;
import java.util.List;

/**
 * 活动方案明细表(ActivityPlanItem)
 *
 * @author wanghaojia
 * @since 2022-11-01 14:39:19
 */
@ApiModel(value = "ActivityPlanItemVo", description = "活动方案明细表Vo")
@Getter
@Setter
public class ActivityPlanItemVo extends ActivityPlanItemBase {

    /**
     * 剩余可用金额（元）
     */
    @ApiModelProperty("剩余可用金额（元）")
    private BigDecimal usableAmount;

    @ApiModelProperty("是否破价")
    private String isBreakPrice;
    @ApiModelProperty("是否完全结案")
    private String wholeAudit;

    /**
     * 已结案金额
     */
    @ApiModelProperty("已结案金额")
    private BigDecimal alreadyAuditAmount;


    @ApiModelProperty("门店明细")
    private List<ActivityPlanItemTerminalVo> activityPlanItemTerminalList;

    /**
     * 预算使用信息
     */
    @ApiModelProperty("预算使用信息")
    private List<ActivityPlanBudgetVo> budgetShares;

    /**
     * 查询使用
     */
    @ApiModelProperty("是否完全承接")
    private String fullAccept;

    @ApiModelProperty("关联上级方案，是否完全承接")
    private String headMonthBudgetFullAccept;

    @ApiModelProperty("关联策略，是否完全承接")
    private String monthBudgetFullAccept;

    @ApiModelProperty(value = "业态", notes = "")
    private String businessFormatCode;

    @ApiModelProperty("方案类型")
    private String schemeTypeCode;

    /**
     * 区域细分编码
     */
    @ApiModelProperty("区域细分编码")
    private String activityOrgSubdivisionCode;

}

