package com.biz.crm.tpm.business.activity.plan.sdk.vo;


import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

/**
 * 活动方案表-模板配置(ActivityPlan)
 *
 * @author wanghaojia
 * @since 2022-10-31 15:55:57
 */
@ApiModel(value = "ActivityPlanTemplateVo", description = "活动方案表-模板配置Vo")
@Getter
@Setter
public class ActivityPlanTemplateVo extends TenantFlagOpDto {

    /**
     * 方案编码
     */
    @ApiModelProperty("方案编码")
    private String planCode;

    /**
     * 方案模板编码
     */
    @ApiModelProperty("方案模板编码")
    private String templateConfigCode;

    /**
     * 方案模板名称
     */
    @ApiModelProperty("方案模板名称")
    private String templateConfigName;

    /**
     * 核销类型
     */
    @ApiModelProperty("核销类型")
    private String auditType;

    /**
     * 核销条件编码
     */
    @ApiModelProperty("核销条件编码")
    private String auditConditionCode;
    /**
     * 核销条件名称
     */
    @ApiModelProperty("核销条件名称")
    private String auditConditionName;

}

