package com.biz.crm.tpm.business.activity.plan.sdk.vo;


import com.biz.crm.tpm.business.activity.plan.sdk.pojo.ActivityPlanBase;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;
import java.util.List;

/**
 * 活动方案表Vo(ActivityPlan)
 *
 * @author wanghaojia
 * @since 2022-10-31 15:55:57
 */
@ApiModel(value = "ActivityPlanVo", description = "活动方案表Vo")
@Getter
@Setter
public class ActivityPlanVo extends ActivityPlanBase {

    @ApiModelProperty("活动细案明细编码")
    private String detailPlanItemCode;

    /**
     * 已使用金额（元）
     */
    @ApiModelProperty("已使用金额（元）")
    private BigDecimal usedAmount;
    /**
     * 剩余可用金额（元）
     */
    @ApiModelProperty("剩余可用金额（元）")
    private BigDecimal usableAmount;

    @ApiModelProperty("方案类型，数据字典tpm_activity_type")
    private String planType;

    @ApiModelProperty("营销策略")
    private List<ActivityPlanStrategyVo> strategyList;

    @ApiModelProperty("大区方案关联总部方案")
    private List<ActivityPlanRelatePlanVo> relatePlanList;

    @ApiModelProperty("模板配置")
    private List<ActivityPlanTemplateVo> templateList;

    @ApiModelProperty("承接业务单元")
    private String nectBusinessUnitCode;

    @ApiModelProperty("是否已校验 Y:已校验，N:未校验")
    private String isValidate;

    @ApiModelProperty(name = "区域编码(字典MDM_CUSTOMIZE_ORG)", notes = "")
    private String regionCode;

    @ApiModelProperty("冗余字段 组织编码")
    private String orgCode;
    @ApiModelProperty("冗余字段 组织名称")
    private String orgName;
}

