package com.biz.crm.tpm.business.activity.plan.sdk.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author ：dengwei
 * @date ：Created in 2022/12/30 15:30
 * @description：会员红包查询方案
 */
@Data
public class RedPacketQueryScheme2Vo {
    /**
     *方案编码
     */
    @ApiModelProperty("TPM活动编码")
    private String planCode;

    /**
     *方案名称
     */
    @ApiModelProperty("TPM活动名称")
    private String planName;

    /**
     * 方案明细编码
     */
    @ApiModelProperty("TPM活动明细编码")
    private String planDetailCode;

    /**
     * 活动归属部门编码
     */
    @ApiModelProperty("部门编码")
    private String departmentCode;

    /**
     * 活动归属部门名称
     */
    @ApiModelProperty("部门名称")
    private String departmentName;

    /**
     * 供应商编码
     */
    @ApiModelProperty("供应商编码")
    private String supplierCode;

    /**
     * 供应商名称
     */
    @ApiModelProperty("供应商名称")
    private String supplierName;

    /**
     * 活动开始时间
     */
    @ApiModelProperty("活动开始时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date activityBeginDate;
    /**
     * 活动结束时间
     */
    @ApiModelProperty("活动结束时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date activityEndDate;

    /**
     * 预估费用金额
     */
    @ApiModelProperty("费用合计")
    private BigDecimal totalFeeAmount;

    /**
     * 申请数量
     */
    @ApiModelProperty("数量")
    private Integer quantity;

    /**
     * 单价
     */
    @ApiModelProperty("单价")
    private BigDecimal price;

    @ApiModelProperty("预留字段1")
    private String ext1;

    @ApiModelProperty("预留字段2")
    private String ext2;

    @ApiModelProperty("预留字段3")
    private String ext3;

    @ApiModelProperty("预留字段4")
    private String ext4;

    @ApiModelProperty("预留字段5")
    private String ext5;
}
