package com.biz.crm.tpm.business.activity.plan.sdk.vo.submitreportvo;


import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanRelatePlanVo;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanStrategyVo;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanTemplateVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.math.BigDecimal;
import java.util.List;

/**
 * 活动方案表审批页面内容Vo(ActivityPlan)
 *
 * @author wanghaojia
 * @since 2022-10-31 15:55:57
 */
@ApiModel(value = "ActivityPlanSubmitReportSubVo", description = "活动方案表审批页面内容Vo")
@Data
public class ActivityPlanSubmitReportSubVo {

    @ApiModelProperty("唯一id")
    private String id;

    @ApiModelProperty("年月")
    private String yearMonthly;

    /**
     * 前端显示使用的是region，先开始取出来的是编码，最后再将name赋给region
     */
    @ApiModelProperty("区域")
    private String region;
    private String regionName;

    @ApiModelProperty("零售商编码")
    private String systemCode;

    @ApiModelProperty("零售商名称")
    private String systemName;

    @ApiModelProperty("销售目标")
    private String salesTargetStr;
    private BigDecimal salesTarget;
    //垂直销售业绩
    private BigDecimal salesQuantity;

    @ApiModelProperty("批复申请金额")
    private String applyAmountStr;
    private BigDecimal applyAmount;
    private BigDecimal modifyApplyAmount;

    @ApiModelProperty("投产比")
    private String productionRatioStr;
    private BigDecimal productionRatio;
    private BigDecimal modifyProductionRatio;

    @ApiModelProperty("产品编码")
    private String productCode;

    @ApiModelProperty("产品名称")
    private String productName;

    @ApiModelProperty(name = "活动类型编码", notes = "活动类型编码")
    private String activityTypeCode;

    @ApiModelProperty(name = "活动类型名称", notes = "活动类型名称")
    private String activityTypeName;

    @ApiModelProperty("活动形式编码")
    private String activityFormCode;

    @ApiModelProperty("活动形式名称")
    private String activityFormName;

    @ApiModelProperty("活动形式说明")
    private String activityFormDesc;

    @ApiModelProperty("预算项目编码")
    private String budgetItemCode;

    @ApiModelProperty("预算项目名称")
    private String budgetItemName;

    @ApiModelProperty("预算金额（元）")
    private String feeAmountStr;
    private BigDecimal feeAmount;

    @ApiModelProperty("已使用金额")
    private String usedAmountStr;
    private BigDecimal usedAmount;

    @ApiModelProperty("本次使用金额")
    private String useAmountStr;
    private BigDecimal useAmount;
    private BigDecimal modifyUseAmount;

    @ApiModelProperty(name = "预算使用进度", notes = "预算使用进度")
    private String budgetUseProgressStr;
    private BigDecimal budgetUseProgress;

    @ApiModelProperty(name = "salesProgress", value = "销售进度", notes = "销售进度")
    private String salesProgressStr;
    private BigDecimal salesProgress;

    @ApiModelProperty(name = "vsSalesProgress", value = "vs销售进度", notes = "vs销售进度")
    private String vsSalesProgressStr;
    private BigDecimal vsSalesProgress;

}

