package com.biz.crm.tpm.business.activity.put.cost.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.activity.put.cost.sdk.dto.ActivityPutCostDto;
import com.biz.crm.tpm.business.activity.put.cost.sdk.service.ActivityPutCostService;
import com.biz.crm.tpm.business.activity.put.cost.sdk.vo.ActivityPutCostVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author: chenlong
 * @date: 2022/11/11 14:12
 * @description: 电商活动投放费用管理(ActivityForm)表相关的http接口
 */
@RestController
@RequestMapping("/v1/activityPutCost")
@Slf4j
@Api(tags = "电商活动投放费用管理")
public class ActivityPutCostController {

    @Autowired
    private ActivityPutCostService activityPutCostService;

    /**
     * 分页查询所有数据
     *
     * @param pageable           分页对象
     * @param activityPutCostDto 查询dto
     * @return 所有数据
     */
    @ApiOperation(value = "分页查询所有数据")
    @GetMapping("findByConditions")
    public Result<Page<ActivityPutCostVo>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                            @ApiParam(name = "activityPutCostDto", value = "电商活动投放费用主表Dto") ActivityPutCostDto activityPutCostDto) {
        try {
            Page<ActivityPutCostVo> page = this.activityPutCostService.findByConditions(pageable, activityPutCostDto);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 通过主键查询单条数据
     *
     * @param id 主键
     * @return 单条数据
     */
    @ApiOperation(value = "通过主键查询单条数据")
    @GetMapping("{id}")
    public Result<ActivityPutCostVo> findById(@PathVariable @ApiParam(name = "id", value = "主键id") String id) {
        try {
            ActivityPutCostVo activityPutCostVo = this.activityPutCostService.findById(id);
            return Result.ok(activityPutCostVo);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 新增数据
     *
     * @param activityPutCostDto dto对象
     * @return 新增结果
     */
    @ApiOperation(value = "新增数据")
    @PostMapping
    public Result<?> create(@ApiParam(name = "activityPutCostDto", value = "电商活动投放费用主表Dto") @RequestBody ActivityPutCostDto activityPutCostDto) {
        try {
            this.activityPutCostService.create(activityPutCostDto);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 修改数据
     *
     * @param activityPutCostDto dto对象
     * @return 修改结果
     */
    @ApiOperation(value = "修改数据")
    @PatchMapping
    public Result<?> update(@ApiParam(name = "activityPutCostDto", value = "电商活动投放费用主表Dto") @RequestBody ActivityPutCostDto activityPutCostDto) {
        try {
            this.activityPutCostService.update(activityPutCostDto);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 删除数据
     *
     * @param ids 主键结合
     * @return 删除结果
     */
    @ApiOperation(value = "删除数据")
    @DeleteMapping("delete")
    public Result<?> delete(@RequestParam("ids") List<String> ids) {
        try {
            this.activityPutCostService.delete(ids);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 启用
     *
     * @param ids 主键列表
     * @return 启用结果
     */
    @ApiOperation(value = "启用", httpMethod = "PATCH")
    @PatchMapping("/enable")
    public Result<?> enable(@RequestBody List<String> ids) {
        try {
            this.activityPutCostService.enableBatch(ids);
            return Result.ok("启用成功");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 禁用
     *
     * @param ids 主键列表
     * @return 禁用结果
     */
    @ApiOperation(value = "禁用", httpMethod = "PATCH")
    @PatchMapping("/disable")
    public Result<?> disable(@RequestBody List<String> ids) {
        try {
            this.activityPutCostService.disableBatch(ids);
            return Result.ok("禁用成功");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 手动调用京东接口
     */
    @ApiOperation(value = "手动调用京东接口")
    @GetMapping("createByJingdong")
    public Result<?> createByJingdong() {
        try {
            this.activityPutCostService.createByJingdong();
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }
}
