package com.biz.crm.tpm.business.activity.put.cost.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author: chenlong
 * @date: 2022/11/11 11:19
 * @description: 电商活动投放费用管理表
 */
@ApiModel(value = "ActivityPutCost", description = "电商活动投放费用管理表")
@TableName("tpm_activity_put_cost")
@Getter
@Setter
@Entity(name = "tpm_activity_put_cost")
@org.hibernate.annotations.Table(appliesTo = "tpm_activity_put_cost", comment = "电商活动投放费用管理表")
@Table(name = "tpm_activity_put_cost", indexes = {
        @Index(name = "TPM_ACTIVITY_PUT_COST_INDEX1", columnList = "put_cost_code", unique = true)})
public class ActivityPutCost extends TenantFlagOpEntity {

    @ApiModelProperty(name = "日期", notes = "日期")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @Column(name = "put_cost_date", length = 32, columnDefinition = "datetime COMMENT '日期'")
    private Date putCostDate;

    @ApiModelProperty(name = "投放费用编码", notes = "投放费用编码")
    @Column(name = "put_cost_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '投放费用编码'")
    private String putCostCode;

    @ApiModelProperty(name = "平台编码", notes = "平台编码")
    @Column(name = "platform_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '平台编码'")
    private String platformCode;

    @ApiModelProperty(name = "客户编码", notes = "客户编码")
    @Column(name = "customer_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '客户编码'")
    private String customerCode;

    @ApiModelProperty(name = "客户名称", notes = "客户名称")
    @Column(name = "customer_name", length = 256, columnDefinition = "VARCHAR(256) COMMENT '客户名称'")
    private String customerName;

    @ApiModelProperty(name = "费用项", notes = "费用项")
    @Column(name = "cost_item", length = 256, columnDefinition = "VARCHAR(256) COMMENT '费用项'")
    private String costItem;

    @ApiModelProperty(name = "活动形式编码", notes = "活动形式编码")
    @Column(name = "activity_form_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '活动形式编码'")
    private String activityFormCode;

    @ApiModelProperty(name = "活动形式名称", notes = "活动形式名称")
    @Column(name = "activity_form_name", length = 256, columnDefinition = "VARCHAR(256) COMMENT '活动形式名称'")
    private String activityFormName;

    @ApiModelProperty(name = "花费金额", notes = "花费金额")
    @Column(name = "cost_amount", length = 24, columnDefinition = "decimal(24,6) COMMENT '花费金额'")
    private BigDecimal costAmount;

    @ApiModelProperty(name = "订单金额", notes = "订单金额")
    @Column(name = "order_amount", length = 24, columnDefinition = "VARCHAR(128) COMMENT '订单金额'")
    private BigDecimal orderAmount;

    @ApiModelProperty(name = "ROI(投资回收率)", notes = "ROI(投资回收率)")
    @Column(name = "roi", length = 24, columnDefinition = "decimal(24,6) COMMENT 'ROI(投资回收率)'")
    private BigDecimal roi;

    @ApiModelProperty(name = "ROI(投资回收率文本)", notes = "ROI(投资回收率文本)")
    @Column(name = "roi_str", length = 128, columnDefinition = "VARCHAR(128) COMMENT 'ROI(投资回收率文本)'")
    private String roiStr;

    /**
     * 销售机构编码
     */
    @ApiModelProperty("销售机构编码")
    @Column(name = "sales_institution_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售机构编码'")
    private String salesInstitutionCode;

    /**
     * 销售机构名称
     */
    @ApiModelProperty("销售机构名称")
    @Column(name = "sales_institution_name", columnDefinition = "VARCHAR(255) COMMENT '销售机构名称'")
    private String salesInstitutionName;

    /**
     * 渠道编码
     */
    @ApiModelProperty("渠道编码")
    @Column(name = "channel_code", length = 32, columnDefinition = "varchar(32) COMMENT '渠道编码'")
    private String channelCode;

    /**
     * 渠道名称
     */
    @ApiModelProperty("渠道名称")
    @Column(name = "channel_name", columnDefinition = "varchar(255) COMMENT '渠道名称'")
    private String channelName;

    /**
     * 业态
     */
    @ApiModelProperty("业态 数据字典：mdm_business_format")
    @Column(name = "business_format_code", length = 32, columnDefinition = "varchar(32) COMMENT '业态'")
    private String businessFormatCode;
}
