package com.biz.crm.tpm.business.activity.put.cost.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.activity.put.cost.local.entity.ActivityPutCost;
import com.biz.crm.tpm.business.activity.put.cost.sdk.dto.ActivityPutCostDto;
import com.biz.crm.tpm.business.activity.put.cost.sdk.vo.ActivityPutCostVo;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author: chenlong
 * @date: 2022/11/11 11:20
 * @description: 电商活动投放费用管理表(ActivityPutCost)表mybatis访问层
 */
public interface ActivityPutCostMapper extends BaseMapper<ActivityPutCost> {

    /**
     * 分页查询所有数据
     *
     * @param page               分页对象
     * @param activityPutCostDto 查询Dto
     * @return 所有数据
     */
    Page<ActivityPutCostVo> findByConditions(@Param("page") Page<ActivityPutCostVo> page, @Param("costDto") ActivityPutCostDto activityPutCostDto);

    /**
     * 大批量保存
     *
     * @param entities 数据列表
     */
    void bulkSave(@Param("costs") List<ActivityPutCost> entities);

    /**
     * 条件查询所有数据
     * @param putCost 查询参数
     * @return List
     */
    List<ActivityPutCostVo> findListByConditions(@Param("putCost") ActivityPutCostDto putCost);

    BigDecimal getPutCostAmount(@Param("putCostDto") ActivityPutCostDto putCostDto);
}
