package com.biz.crm.tpm.business.activity.put.cost.local.register;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * @author: chenlong
 * @date: 2022/11/11 14:16
 * @description: 电商活动投放费用管理数据视图
 */
@Component
@Slf4j
public class ActivityPutCostDataviewRegister implements DataviewRegister {
    @Override
    public String code() {
        return "tpm_activity_put_cost_data_view";
    }

    @Override
    public String desc() {
        return "TPM-电商活动-投放费用管理";
    }

    @Override
    public String buildSql() {
        return "select t.* from tpm_activity_put_cost t " +
                "where t.tenant_code = :tenantCode " +
                "and t.del_flag = '" + DelFlagStatusEnum.NORMAL.getCode() + "'";
    }
}
