package com.biz.crm.tpm.business.activity.put.cost.local.repository;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.tpm.business.activity.put.cost.local.entity.ActivityPutCost;
import com.biz.crm.tpm.business.activity.put.cost.local.mapper.ActivityPutCostMapper;
import com.biz.crm.tpm.business.activity.put.cost.sdk.dto.ActivityPutCostDto;
import com.biz.crm.tpm.business.activity.put.cost.sdk.vo.ActivityPutCostVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.sql.Wrapper;
import java.util.List;

/**
 * @author: chenlong
 * @date: 2022/11/11 11:21
 * @description: 电商活动投放费用管理表(ActivityPutCost)表数据库访问层
 */
@Component
public class ActivityPutCostRepository extends ServiceImpl<ActivityPutCostMapper, ActivityPutCost> {

    @Autowired(required = false)
    private ActivityPutCostMapper activityPutCostMapper;

    /**
     * 分页查询数据
     *
     * @param pageable           分页对象
     * @param activityPutCostDto 查询Dto
     * @return Page<ActivityPutCostVo>
     */
    public Page<ActivityPutCostVo> findByConditions(Pageable pageable, ActivityPutCostDto activityPutCostDto) {
        Page<ActivityPutCostVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        return this.activityPutCostMapper.findByConditions(page, activityPutCostDto);
    }

    /**
     * 大批量保存
     *
     * @param entities 数据列表
     */
    public void bulkSave(List<ActivityPutCost> entities) {
        if (CollectionUtils.isEmpty(entities)) {
            return;
        }
        //保存
        this.activityPutCostMapper.bulkSave(entities);
    }

    public List<ActivityPutCostVo> findList(ActivityPutCostDto putCost){
        return this.activityPutCostMapper.findListByConditions(putCost);
    }

    public BigDecimal getPutCostAmount(ActivityPutCostDto putCost){
        return this.activityPutCostMapper.getPutCostAmount(putCost);
    }

    /**
     * 按条件删除
     *
     * @param putCost
     */
    public void deleteByConditions(ActivityPutCostDto putCost) {
        lambdaUpdate().in(ActivityPutCost::getCustomerCode, putCost.getCustomerCodeList())
                .in(ActivityPutCost::getCostItem, putCost.getCostItemList())
                .eq(ActivityPutCost::getPutCostDate, putCost.getPutCostDate())
                .remove();
    }

}
