package com.biz.crm.tpm.business.activity.put.cost.local.service.internal;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.customer.channel.sdk.service.CustomerChannelVoService;
import com.biz.crm.mdm.business.customer.channel.sdk.vo.CustomerChannelVo;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.third.system.jd.sdk.enums.JingdongAccountTypeEnum;
import com.biz.crm.mn.third.system.jd.sdk.service.JingdongService;
import com.biz.crm.mn.third.system.jd.sdk.vo.JingdongBalanceVo;
import com.biz.crm.tpm.business.activity.form.sdk.service.ActivityFormService;
import com.biz.crm.tpm.business.activity.form.sdk.vo.ActivityFormVo;
import com.biz.crm.tpm.business.activity.put.cost.local.entity.ActivityPutCost;
import com.biz.crm.tpm.business.activity.put.cost.local.repository.ActivityPutCostRepository;
import com.biz.crm.tpm.business.activity.put.cost.sdk.constant.ActivityPutCostConstant;
import com.biz.crm.tpm.business.activity.put.cost.sdk.dto.ActivityPutCostDto;
import com.biz.crm.tpm.business.activity.put.cost.sdk.dto.ActivityPutCostLogEventDto;
import com.biz.crm.tpm.business.activity.put.cost.sdk.event.log.ActivityPutCostEventListener;
import com.biz.crm.tpm.business.activity.put.cost.sdk.service.ActivityPutCostService;
import com.biz.crm.tpm.business.activity.put.cost.sdk.vo.ActivityPutCostVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import com.google.common.collect.Lists;
import jodd.util.StringUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author: chenlong
 * @date: 2022/11/11 14:07
 * @description: 电商活动投放费用管理(ActivityFormAudit)表服务实现类
 */
@Service("activityPutCostService")
@Slf4j
public class ActivityPutCostServiceImpl implements ActivityPutCostService {

    @Autowired(required = false)
    private ActivityPutCostRepository activityPutCostRepository;
    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required = false)
    private GenerateCodeService generateCodeService;
    @Autowired(required = false)
    private LoginUserService loginUserService;
    @Autowired(required = false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required = false)
    private JingdongService jingdongService;
    @Autowired(required = false)
    private CustomerVoService customerVoService;
    @Autowired(required = false)
    private CustomerChannelVoService customerChannelVoService;
    @Autowired(required = false)
    private SalesOrgVoService salesOrgVoService;
    @Autowired(required = false)
    private ActivityFormService activityFormService;

    /**
     * 分页查询所有数据
     *
     * @param pageable           分页对象
     * @param activityPutCostDto 查询dto
     * @return 所有数据
     */
    @Override
    public Page<ActivityPutCostVo> findByConditions(Pageable pageable, ActivityPutCostDto activityPutCostDto) {
        pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(1, 50));
        if (Objects.isNull(activityPutCostDto)) {
            activityPutCostDto = new ActivityPutCostDto();
        }
        return this.activityPutCostRepository.findByConditions(pageable, activityPutCostDto);
    }

    /**
     * 通过主键查询单条数据
     *
     * @param id 主键
     * @return 单条数据
     */
    @Override
    public ActivityPutCostVo findById(String id) {
        if (StringUtils.isBlank(id)) {
            return null;
        }
        ActivityPutCost applyRules = this.activityPutCostRepository.getById(id);
        if (null == applyRules) {
            return null;
        }
        return this.nebulaToolkitService.copyObjectByWhiteList(applyRules, ActivityPutCostVo.class, null, null);

    }

    /**
     * 新增数据
     *
     * @param activityPutCostDto dto对象
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void create(ActivityPutCostDto activityPutCostDto) {
        this.createValidate(activityPutCostDto);
        //判断数据重复
        int count = this.activityPutCostRepository.lambdaQuery()
                .eq(ActivityPutCost::getPutCostDate, activityPutCostDto.getPutCostDate())
                .eq(ActivityPutCost::getCustomerCode, activityPutCostDto.getCustomerCode())
                .eq(ActivityPutCost::getCostItem, activityPutCostDto.getCostItem())
                .eq(ActivityPutCost::getDelFlag, DelFlagStatusEnum.NORMAL.getCode()).count();
        Validate.isTrue(count == 0, "已存在相同维度的投放费用，请勿重复添加");

        if (BigDecimal.ZERO.compareTo(activityPutCostDto.getOrderAmount()) == 0 || BigDecimal.ZERO.compareTo(activityPutCostDto.getCostAmount()) == 0) {
            activityPutCostDto.setRoi(BigDecimal.ZERO);
        } else {
            activityPutCostDto.setRoi(activityPutCostDto.getOrderAmount().multiply(new BigDecimal(100)).divide(activityPutCostDto.getCostAmount(), 2));
        }
        activityPutCostDto.setRoiStr(activityPutCostDto.getRoi().toString() + "%");

        ActivityPutCost putCost = nebulaToolkitService.copyObjectByWhiteList(activityPutCostDto, ActivityPutCost.class, null, null);

//        String ruleCode = StringUtils.join(ActivityPutCostConstant.ACTIVITY_PUT_COST_PREFIX, DateFormatUtils.format(new Date(), DateUtil.DEFAULT_YEAR_MONTH_DAY_NO_CH));
        String code = this.generateCodeService.generateCode(ActivityPutCostConstant.ACTIVITY_PUT_COST_PREFIX, 1, 5, 2, TimeUnit.DAYS).get(0);
        putCost.setPutCostCode(code);
        putCost.setTenantCode(TenantUtils.getTenantCode());
        putCost.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        putCost.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        this.activityPutCostRepository.save(putCost);

        //新增业务日志
        ActivityPutCostLogEventDto logEventDto = new ActivityPutCostLogEventDto();
        logEventDto.setOriginal(null);
        logEventDto.setNewest(activityPutCostDto);
        SerializableBiConsumer<ActivityPutCostEventListener, ActivityPutCostLogEventDto> onCreate =
                ActivityPutCostEventListener::onCreate;
        this.nebulaNetEventClient.publish(logEventDto, ActivityPutCostEventListener.class, onCreate);
    }

    /**
     * 创建验证
     *
     * @param putCostDto dto对象
     */
    private void createValidate(ActivityPutCostDto putCostDto) {
        Validate.notNull(putCostDto, "新增时，对象信息不能为空！");
        putCostDto.setId(null);
        Validate.notNull(putCostDto.getPutCostDate(), "新增时，日期不能为空！");
        Validate.notBlank(putCostDto.getPlatformCode(), "新增时，平台不能为空！");
        Validate.notBlank(putCostDto.getCustomerCode(), "新增时，客户编码不能为空！");
        Validate.notBlank(putCostDto.getCustomerName(), "新增时，客户名称不能为空！");
        Validate.notBlank(putCostDto.getCostItem(), "新增时，费用项不能为空！");
        Validate.notNull(putCostDto.getCostAmount(), "新增时，花费金额不能为空！");
        Validate.notNull(putCostDto.getOrderAmount(), "新增时，订单金额不能为空！");
    }

    /**
     * 修改数据
     *
     * @param activityPutCostDto dto对象
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void update(ActivityPutCostDto activityPutCostDto) {
        this.updateValidate(activityPutCostDto);
        //判断数据重复
        int count = this.activityPutCostRepository.lambdaQuery()
                .eq(ActivityPutCost::getPutCostDate, activityPutCostDto.getPutCostDate())
                .eq(ActivityPutCost::getCustomerCode, activityPutCostDto.getCustomerCode())
                .eq(ActivityPutCost::getCostItem, activityPutCostDto.getCostItem())
                .eq(ActivityPutCost::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .ne(ActivityPutCost::getId, activityPutCostDto.getId()).count();
        Validate.isTrue(count == 0, "已存在相同维度的投放费用，请勿重复添加");

        if (BigDecimal.ZERO.compareTo(activityPutCostDto.getOrderAmount()) == 0 || BigDecimal.ZERO.compareTo(activityPutCostDto.getCostAmount()) == 0) {
            activityPutCostDto.setRoi(BigDecimal.ZERO);
        } else {
            activityPutCostDto.setRoi(activityPutCostDto.getOrderAmount().multiply(new BigDecimal(100)).divide(activityPutCostDto.getCostAmount(), 2));
        }
        activityPutCostDto.setRoiStr(activityPutCostDto.getRoi().toString() + "%");

        //获取历史vo
        ActivityPutCostVo oldVo = this.findById(activityPutCostDto.getId());


        ActivityPutCost putCost = nebulaToolkitService.copyObjectByWhiteList(activityPutCostDto, ActivityPutCost.class, null, null);
        this.activityPutCostRepository.updateById(putCost);

        //编辑业务日志
        ActivityPutCostLogEventDto logEventDto = new ActivityPutCostLogEventDto();
        logEventDto.setOriginal(oldVo);
        logEventDto.setNewest(activityPutCostDto);
        SerializableBiConsumer<ActivityPutCostEventListener, ActivityPutCostLogEventDto> onUpdate =
                ActivityPutCostEventListener::onUpdate;
        this.nebulaNetEventClient.publish(logEventDto, ActivityPutCostEventListener.class, onUpdate);
    }

    /**
     * 编辑验证
     *
     * @param putCostDto dto对象
     */
    private void updateValidate(ActivityPutCostDto putCostDto) {
        Validate.notNull(putCostDto, "编辑时，对象信息不能为空！");
        Validate.notBlank(putCostDto.getId(), "编辑数据时，id不能为空！");
        Validate.notNull(putCostDto.getPutCostDate(), "编辑时，日期不能为空！");
        Validate.notBlank(putCostDto.getPlatformCode(), "编辑时，平台不能为空！");
        Validate.notBlank(putCostDto.getCustomerCode(), "编辑时，客户编码不能为空！");
        Validate.notBlank(putCostDto.getCustomerName(), "编辑时，客户名称不能为空！");
        Validate.notBlank(putCostDto.getCostItem(), "编辑时，费用项不能为空！");
        Validate.notNull(putCostDto.getCostAmount(), "编辑时，花费金额不能为空！");
        Validate.notNull(putCostDto.getOrderAmount(), "编辑时，订单金额不能为空！");
    }

    /**
     * 删除数据
     *
     * @param idList 主键结合
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void delete(List<String> idList) {
        Validate.isTrue(!CollectionUtils.isEmpty(idList), "删除数据时，主键集合不能为空！");
        List<ActivityPutCost> costList = this.activityPutCostRepository.listByIds(idList);
        ArrayList<ActivityPutCost> costArrayList = new ArrayList<>();
        costList.forEach(item -> {
            ActivityPutCost cost = new ActivityPutCost();
            cost.setId(item.getId());
            cost.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
            costArrayList.add(cost);

            //删除业务日志
            ActivityPutCostLogEventDto logEventDto = new ActivityPutCostLogEventDto();
            ActivityPutCostVo oldVo = this.nebulaToolkitService.copyObjectByWhiteList(item, ActivityPutCostVo.class, null, null);
            logEventDto.setOriginal(oldVo);
            ActivityPutCostDto newDto = this.nebulaToolkitService.copyObjectByWhiteList(item, ActivityPutCostDto.class, null, null);
            newDto.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
            logEventDto.setNewest(newDto);
            SerializableBiConsumer<ActivityPutCostEventListener, ActivityPutCostLogEventDto> onDelete =
                    ActivityPutCostEventListener::onDelete;
            this.nebulaNetEventClient.publish(logEventDto, ActivityPutCostEventListener.class, onDelete);
        });
        this.activityPutCostRepository.updateBatchById(costArrayList);
    }

    /**
     * 启用
     *
     * @param ids 主键列表
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void enableBatch(List<String> ids) {
        Validate.isTrue(!CollectionUtils.isEmpty(ids), "请选择要操作的数据");
        List<ActivityPutCost> costList = this.activityPutCostRepository.listByIds(ids);
        Validate.isTrue(!CollectionUtils.isEmpty(costList), "不存在或已删除!");

        ArrayList<ActivityPutCost> costArrayList = new ArrayList<>();
        costList.forEach(item -> {
            ActivityPutCost cost = new ActivityPutCost();
            cost.setId(item.getId());
            cost.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            costArrayList.add(cost);

            //禁用业务日志
            ActivityPutCostLogEventDto logEventDto = new ActivityPutCostLogEventDto();
            ActivityPutCostVo oldVo = this.nebulaToolkitService.copyObjectByWhiteList(item, ActivityPutCostVo.class, null, null);
            logEventDto.setOriginal(oldVo);
            ActivityPutCostDto newDto = this.nebulaToolkitService.copyObjectByWhiteList(item, ActivityPutCostDto.class, null, null);
            newDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            logEventDto.setNewest(newDto);
            SerializableBiConsumer<ActivityPutCostEventListener, ActivityPutCostLogEventDto> onEnable =
                    ActivityPutCostEventListener::onEnable;
            this.nebulaNetEventClient.publish(logEventDto, ActivityPutCostEventListener.class, onEnable);
        });
        this.activityPutCostRepository.updateBatchById(costArrayList);
    }

    /**
     * 禁用
     *
     * @param ids 主键列表
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void disableBatch(List<String> ids) {
        Validate.isTrue(!CollectionUtils.isEmpty(ids), "请选择要操作的数据");
        List<ActivityPutCost> costList = this.activityPutCostRepository.listByIds(ids);
        Validate.isTrue(!CollectionUtils.isEmpty(costList), "不存在或已删除!");

        ArrayList<ActivityPutCost> costArrayList = new ArrayList<>();
        costList.forEach(item -> {
            ActivityPutCost cost = new ActivityPutCost();
            cost.setId(item.getId());
            cost.setEnableStatus(EnableStatusEnum.DISABLE.getCode());
            costArrayList.add(cost);

            //禁用业务日志
            ActivityPutCostLogEventDto logEventDto = new ActivityPutCostLogEventDto();
            ActivityPutCostVo oldVo = this.nebulaToolkitService.copyObjectByWhiteList(item, ActivityPutCostVo.class, null, null);
            logEventDto.setOriginal(oldVo);
            ActivityPutCostDto newDto = this.nebulaToolkitService.copyObjectByWhiteList(item, ActivityPutCostDto.class, null, null);
            newDto.setEnableStatus(EnableStatusEnum.DISABLE.getCode());
            logEventDto.setNewest(newDto);
            SerializableBiConsumer<ActivityPutCostEventListener, ActivityPutCostLogEventDto> onDisable =
                    ActivityPutCostEventListener::onDisable;
            this.nebulaNetEventClient.publish(logEventDto, ActivityPutCostEventListener.class, onDisable);
        });
        this.activityPutCostRepository.updateBatchById(costArrayList);
    }

    /**
     * 大批量保存
     *
     * @param importList 导入数据列表
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void bulkImportSave(List<ActivityPutCostDto> importList) {
        if (CollectionUtils.isEmpty(importList)) {
            return;
        }
//        String ruleCode = StringUtils.join(ActivityPutCostConstant.ACTIVITY_PUT_COST_PREFIX, DateFormatUtils.format(new Date(), DateUtil.DEFAULT_YEAR_MONTH_DAY_NO_CH));
        List<String> codes = this.generateCodeService.generateCode(ActivityPutCostConstant.ACTIVITY_PUT_COST_PREFIX, importList.size(), 5, 2, TimeUnit.DAYS);
        Collection<ActivityPutCost> entities = this.nebulaToolkitService.copyCollectionByWhiteList(importList, ActivityPutCostDto.class, ActivityPutCost.class, LinkedHashSet.class, ArrayList.class);
        List<ActivityPutCost> costList = Lists.newArrayList(entities);

        //设置基础信息
        AbstractCrmUserIdentity loginDetails = this.loginUserService.getAbstractLoginUser();
        Date date = new Date();

        for (int i = 0; i < importList.size(); i++) {
            ActivityPutCost cost = costList.get(i);
            cost.setPutCostCode(codes.get(i));

            cost.setCreateAccount(loginDetails.getUsername());
            cost.setCreateName(loginDetails.getRealName());
            cost.setModifyAccount(loginDetails.getUsername());
            cost.setModifyName(loginDetails.getRealName());
            cost.setCreateTime(date);
            cost.setModifyTime(date);
            cost.setTenantCode(loginDetails.getTenantCode());
            cost.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            cost.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        }
        log.error("组装数据完成:{}", costList);
        //分批保存
        List<List<ActivityPutCost>> costs = Lists.partition(costList, 500);
        for (List<ActivityPutCost> list : costs) {
            this.activityPutCostRepository.bulkSave(list);
            for (ActivityPutCost cost : list) {
                //新增业务日志
                ActivityPutCostLogEventDto logEventDto = new ActivityPutCostLogEventDto();
                logEventDto.setOriginal(null);

                ActivityPutCostDto dto = this.nebulaToolkitService.copyObjectByWhiteList(cost, ActivityPutCostDto.class, null, null);
                logEventDto.setNewest(dto);
                SerializableBiConsumer<ActivityPutCostEventListener, ActivityPutCostLogEventDto> onCreate =
                        ActivityPutCostEventListener::onCreate;
                this.nebulaNetEventClient.publish(logEventDto, ActivityPutCostEventListener.class, onCreate);
            }
        }
    }

    @Override
    public List<ActivityPutCostVo> findByCusterCodeAndPutCostDate(ActivityPutCostDto putCost) {
        return this.activityPutCostRepository.findList(putCost);
    }

    @Override
    public BigDecimal getPutCostAmount(ActivityPutCostDto putCost) {
        return this.activityPutCostRepository.getPutCostAmount(putCost);
    }

    /**
     * 京东接口生成平台投放费用
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    @DynamicTaskService(cornExpression = "0 30 14 * * ?", taskDesc = "每天 14:30 执行一次京东接口获取昨日消耗")
    public void createByJingdong() {
        loginUserService.refreshAuthentication(null);
        AbstractCrmUserIdentity loginUser = loginUserService.getAbstractLoginUser();

        List<JingdongBalanceVo> jtkList = Optional.ofNullable(jingdongService.getJtkBalance()).orElse(Collections.emptyList());
        List<JingdongBalanceVo> jrwList = Optional.ofNullable(jingdongService.getJrwBalance()).orElse(Collections.emptyList());

        Map<String, List<CustomerVo>> customerVoMap;
        Map<String, List<SalesOrgVo>> orgVoMap;
        Map<String, CustomerChannelVo> channelVoMap;
        Map<String, ActivityFormVo> formMap;
        //查询渠道
        List<CustomerChannelVo> channelList = customerChannelVoService.findByCodes(Collections.singletonList("20"));
        if (!CollectionUtils.isEmpty(channelList)) {
            channelVoMap = channelList.stream().collect(Collectors.toMap(CustomerChannelVo::getCustomerChannelCode, Function.identity()));
        } else {
            throw new IllegalArgumentException("未找到任意渠道，请检查！");
        }
        // 客户
        List<String> customerCodeList = jtkList.stream()
                .filter(k -> StringUtil.isNotEmpty(k.getCustomerMdgCode()))
                .map(JingdongBalanceVo::getCustomerMdgCode).distinct().collect(Collectors.toList());
        List<CustomerVo> customerVos = customerVoService.findByCustomerMdgCodes(customerCodeList);
        if (!CollectionUtils.isEmpty(customerVos)) {
            customerVoMap = customerVos.stream().collect(Collectors.groupingBy(CustomerVo::getErpCode));
        } else {
            throw new IllegalArgumentException("未找到任意客户，请检查！");
        }
        //销售机构
        List<SalesOrgVo> orgVos = salesOrgVoService.findByErpCodeList(Collections.singletonList("1171"));
        if (!CollectionUtils.isEmpty(orgVos)) {
            orgVoMap = orgVos.stream().collect(Collectors.groupingBy(SalesOrgVo::getErpCode));
        } else {
            throw new IllegalArgumentException("未找到任意销售机构，请检查！");
        }
        //活动形式
        List<ActivityFormVo> formVoList = activityFormService.findByNames(Arrays.asList("京挑客", "京任务"));
        if (!CollectionUtils.isEmpty(formVoList)) {
            formMap = formVoList.stream().collect(Collectors.toMap(ActivityFormVo::getActivityFormName, Function.identity()));
        } else {
            throw new IllegalArgumentException("未找到任意活动形式，请检查！");
        }

        Map<String, BigDecimal> jrwMap = jrwList.stream()
                .filter(Objects::nonNull)
                .filter(k -> StringUtil.isNotEmpty(k.getCustomerMdgCode()))
                .collect(Collectors.toMap(JingdongBalanceVo::getCustomerMdgCode,
                        JingdongBalanceVo::getYesterDayCost, (n, o) -> n));
        List<ActivityPutCost> activityPutCostList = new ArrayList<>();
        for (JingdongBalanceVo jtkBalance : jtkList) {
            if (StringUtil.isEmpty(jtkBalance.getCustomerMdgCode())){
                continue;
            }
            ActivityPutCost putCostJtk = new ActivityPutCost();
            //*业态	默认常温
            //*渠道编码	默认20
            //渠道名称	默认经销
            //*销售机构编码	默认1171
            //销售机构名称	根据默认编码带出
            //*客户MDG编码	通过店铺名称与系统主数据中的客户编码对应(店铺名称+业态+渠道+销售机构+电商平台)
            //客户名称	通过access_token与店铺名一一对应
            //*日期	timestamp	时间戳，格式为yyyy-MM-dd	注意返回值为昨日扣费，时间也应同步
            //*平台	通过业态+渠道+销售机构+客户查找主数据中的平台
            //费用项	京挑客服务费 编码为JD0014 / 京任务服务费    编码为JRW01
            //*活动形式编码	通过活动形式取对应的活动形式编码
            //活动形式	该接口下默认京挑客
            putCostJtk.setBusinessFormatCode(ActivityPutCostConstant.CW);
            putCostJtk.setChannelCode("20");
            putCostJtk.setSalesInstitutionCode("1171");
            putCostJtk.setCustomerCode(jtkBalance.getCustomerMdgCode());
            Date lastDay = DateUtil.parseDate(DateUtil.dateStrYYYYMMDD(DateUtil.getDayByDateDistance(new Date(), -1)), "yyyy-MM-dd");
            putCostJtk.setPutCostDate(lastDay);
            if (JingdongAccountTypeEnum.JINGDONG_JRW.getCustomerMdgCode().equals(jtkBalance.getCustomerMdgCode())) {
                putCostJtk.setPlatformCode(ActivityPutCostConstant.ACTIVITY_PUT_COST_PLATFORM_DICT_JD_SC);
            } else {
                putCostJtk.setPlatformCode(ActivityPutCostConstant.ACTIVITY_PUT_COST_PLATFORM_DICT_JD_SC2);
            }

            //渠道
            putCostJtk.setChannelName(channelVoMap.get(putCostJtk.getChannelCode()).getCustomerChannelName());
            //组织
            SalesOrgVo salesOrgVo;
            List<SalesOrgVo> list = orgVoMap.get(putCostJtk.getSalesInstitutionCode());
            if (CollectionUtil.isEmpty(list)) {
                throw new IllegalArgumentException("销售机构编码【" + putCostJtk.getSalesInstitutionCode() + "】未找到对应销售机构，请检查！");
            }
            salesOrgVo = list.stream()
                    .filter(e -> StringUtil.isNotEmpty(e.getChannelCode()))
                    .filter(e -> StringUtil.isNotEmpty(e.getBusinessFormatCode()))
                    .filter(e -> e.getChannelCode().equals(putCostJtk.getChannelCode()))
                    .filter(e -> e.getBusinessFormatCode().equals(putCostJtk.getBusinessFormatCode()))
                    .findFirst().orElse(null);
            if (salesOrgVo == null) {
                throw new IllegalArgumentException("销售机构编码【" + putCostJtk.getSalesInstitutionCode() + "】未找到对应销售机构，请检查！");
            }
            SalesOrgVo finalSalesOrgVo = salesOrgVo;
            putCostJtk.setSalesInstitutionName(salesOrgVo.getSalesOrgName());
            //客户
            List<CustomerVo> customerList = customerVoMap.get(putCostJtk.getCustomerCode());
            if (CollectionUtil.isEmpty(customerList)) {
                throw new IllegalArgumentException("客户编码【" + putCostJtk.getCustomerCode() + "】未找到对应客户，请检查！");
            }
            CustomerVo customerVo = customerList.stream()
                    .filter(e -> StringUtil.isNotEmpty(e.getCustomerChannelCode()))
                    .filter(e -> StringUtil.isNotEmpty(e.getSalesInstitutionCode()))
                    .filter(e -> StringUtil.isNotEmpty(e.getBusinessFormatCode()))
                    .filter(e -> e.getCustomerChannelCode().equals(putCostJtk.getChannelCode()))
                    .filter(e -> e.getSalesInstitutionCode().equals(finalSalesOrgVo.getSalesInstitutionCode()))
                    .filter(e -> e.getBusinessFormatCode().equals(putCostJtk.getBusinessFormatCode()))
                    .findFirst().orElse(null);
            if (customerVo == null) {
                throw new IllegalArgumentException("客户编码【" + putCostJtk.getCustomerCode() + "】未找到对应客户，请检查！");
            }
            putCostJtk.setCustomerName(customerVo.getCustomerName());

            putCostJtk.setTenantCode(TenantUtils.getTenantCode());
            putCostJtk.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            putCostJtk.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());

            ActivityPutCost putCostJrw = this.nebulaToolkitService.copyObjectByWhiteList(putCostJtk, ActivityPutCost.class, LinkedHashSet.class, ArrayList.class);

            //活动形式
            putCostJtk.setActivityFormCode(formMap.get("京挑客").getActivityFormCode());
            putCostJtk.setActivityFormName(formMap.get("京挑客").getActivityFormName());
            putCostJtk.setCostItem("JD0014");
            putCostJtk.setCostAmount(jtkBalance.getYesterDayCost());
            putCostJrw.setActivityFormCode(formMap.get("京任务").getActivityFormCode());
            putCostJrw.setActivityFormName(formMap.get("京任务").getActivityFormName());
            putCostJrw.setCostItem("JRW01");
            putCostJrw.setCostAmount(jrwMap.get(putCostJtk.getCustomerCode()));

            activityPutCostList.add(putCostJtk);
            activityPutCostList.add(putCostJrw);
        }

        //删除旧数据
        ActivityPutCostDto dto = new ActivityPutCostDto();
        dto.setCustomerCodeList(customerCodeList);
        dto.setCostItemList(Arrays.asList("JD0014", "JRW01"));
        dto.setPutCostDate(activityPutCostList.get(0).getPutCostDate());
        activityPutCostRepository.deleteByConditions(dto);

        List<String> codeList = this.generateCodeService.generateCode(ActivityPutCostConstant.ACTIVITY_PUT_COST_PREFIX, jtkList.size() + jrwList.size(), 5, 2, TimeUnit.DAYS);
        for (int i = 0; i < activityPutCostList.size(); i++) {
            activityPutCostList.get(i).setPutCostCode(codeList.get(i));
        }
        this.activityPutCostRepository.saveBatch(activityPutCostList);
    }
}
