package com.biz.crm.tpm.business.agency.operation.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.agency.operation.sdk.dto.AgencyOperationFeeDto;
import com.biz.crm.tpm.business.agency.operation.sdk.service.AgencyOperationFeeService;
import com.biz.crm.tpm.business.agency.operation.sdk.vo.AgencyOperationFeeTableVo;
import com.biz.crm.tpm.business.agency.operation.sdk.vo.AgencyOperationFeeVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.LinkedHashMap;
import java.util.List;

/**
 * @author: yaoyongming
 * @date: 2023/8/23 16:25
 */
@RestController
@RequestMapping("/v1/agencyOperationFeeController")
@Slf4j
@Api(tags = "代运营费用")
public class AgencyOperationFeeController {

    /**
     * 服务对象
     */
    @Autowired(required = false)
    private AgencyOperationFeeService agencyOperationFeeService;


    /**
     * 新增数据
     *
     * @param agencyOperationFee 实体对象
     * @return 新增结果
     */
    @ApiOperation(value = "新增数据")
    @PostMapping
    public Result<?> create(@ApiParam(name = "agencyOperationFee", value = "代运营费用") @RequestBody AgencyOperationFeeDto agencyOperationFee) {
        try {
            this.agencyOperationFeeService.create(agencyOperationFee);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 通过主键查询单条数据
     *
     * @param id 主键
     * @return 单条数据
     */
    @ApiOperation(value = "通过主键查询单条数据")
    @GetMapping("{id}")
    public Result<AgencyOperationFeeVo> findById(@PathVariable @ApiParam(name = "id", value = "主键id", required = true) String id) {
        try {
            AgencyOperationFeeVo vo = this.agencyOperationFeeService.findById(id);
            return Result.ok(vo);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 修改数据
     *
     * @param agencyOperationFee 实体对象
     * @return 修改结果
     */
    @ApiOperation(value = "修改数据")
    @PatchMapping
    public Result<?> update(@ApiParam(name = "agencyOperationFee", value = "代运营费用") @RequestBody AgencyOperationFeeDto agencyOperationFee) {
        try {
            this.agencyOperationFeeService.update(agencyOperationFee);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 获取实际展示字段
     *
     * @param platformCode
     * @return
     */
    @ApiOperation(value = "获取实际展示字段")
    @GetMapping("showFields")
    public Result<LinkedHashMap<String, String>> showFields(@ApiParam(name = "platformCode", value = "平台编码") @RequestParam String platformCode) {
        try {
            return Result.ok(this.agencyOperationFeeService.showFields(platformCode));
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 费用计算
     *
     * @param agencyOperationFee 实体对象
     * @return 新增结果
     */
    @ApiOperation(value = "费用计算")
    @PostMapping("calculationFee")
    public Result<List<AgencyOperationFeeTableVo>> calculationFee(@ApiParam(name = "agencyOperationFee", value = "代运营费用") @RequestBody AgencyOperationFeeDto agencyOperationFee) {
        try {
            return Result.ok(this.agencyOperationFeeService.calculationFee(agencyOperationFee));
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 删除数据
     *
     * @param ids 主键结合
     * @return 删除结果
     */
    @ApiOperation(value = "删除数据")
    @DeleteMapping
    public Result<?> delete(@ApiParam(name = "ids", value = "主键集合") @RequestParam("ids") List<String> ids) {
        try {
            this.agencyOperationFeeService.delete(ids);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }
}
