package com.biz.crm.tpm.business.agency.operation.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.agency.operation.sdk.service.AgencyOperationServiceWeightService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author: yaoyongming
 * @date: 2023/8/16 16:25
 */
@RestController
@RequestMapping("/v1/agencyOperationServiceWeightController")
@Slf4j
@Api(tags = "代运营服务费&权重")
public class AgencyOperationServiceWeightController {

    /**
     * 服务对象
     */
    @Autowired(required = false)
    private AgencyOperationServiceWeightService agencyOperationServiceWeightService;

    /**
     * 删除数据
     *
     * @param ids 主键结合
     * @return 删除结果
     */
    @ApiOperation(value = "删除数据")
    @DeleteMapping
    public Result<?> delete(@ApiParam(name = "ids", value = "主键集合") @RequestParam("ids") List<String> ids) {
        try {
            this.agencyOperationServiceWeightService.delete(ids);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }
}
