package com.biz.crm.tpm.business.agency.operation.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * 代运营目标
 *
 * @author yaoyongming
 * @create 2023-08-19 15:20
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "AgencyOperationGoal", description = "代运营目标")
@Entity
@org.hibernate.annotations.Table(appliesTo = "`tpm_agency_operation_goal`", comment = "代运营目标")
@TableName("tpm_agency_operation_goal")
@Table(
        name = "`tpm_agency_operation_goal`",
        indexes = {
                @Index(name = "agency_operation_goal_idx1", columnList = "unique_key"),
                @Index(name = "agency_operation_goal_idx2", columnList = "business_format_code"),
                @Index(name = "agency_operation_goal_idx3", columnList = "channel_code"),
                @Index(name = "agency_operation_goal_idx4", columnList = "sales_institution_code"),
                @Index(name = "agency_operation_goal_idx5", columnList = "customer_code"),
                @Index(name = "agency_operation_goal_idx6", columnList = "supplier_code"),
                @Index(name = "agency_operation_goal_idx7", columnList = "year_month_ly")
        })
public class AgencyOperationGoal extends TenantFlagOpEntity {

    /**
     * 唯一标识
     */
    @ApiModelProperty("唯一标识")
    @Column(name = "unique_key", length = 128, columnDefinition = "varchar(128) COMMENT '唯一标识'")
    private String uniqueKey;

    /**
     * 业态[数据字典:mdm_business_format]
     */
    @ApiModelProperty(name = "businessFormatCode", notes = "业态[数据字典:mdm_business_format]")
    @Column(name = "business_format_code",  length = 32, columnDefinition = "VARCHAR(32) COMMENT '业态[数据字典:mdm_business_format] '")
    private String businessFormatCode;

    /**
     * 渠道编码
     */
    @ApiModelProperty("渠道编码")
    @Column(name = "channel_code", length = 32, columnDefinition = "varchar(32) COMMENT '渠道编码'")
    private String channelCode;

    /**
     * 渠道名称
     */
    @ApiModelProperty("渠道名称")
    @Column(name = "channel_name", columnDefinition = "varchar(255) COMMENT '渠道名称'")
    private String channelName;

    /**
     * 销售机构编码
     */
    @ApiModelProperty("销售机构编码")
    @Column(name = "sales_institution_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售机构编码'")
    private String salesInstitutionCode;

    /**
     * 销售机构名称
     */
    @ApiModelProperty("销售机构名称")
    @Column(name = "sales_institution_name", columnDefinition = "VARCHAR(255) COMMENT '销售机构名称'")
    private String salesInstitutionName;

    /**
     * 客户编码
     */
    @ApiModelProperty("客户编码")
    @Column(name = "customer_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '客户编码'")
    private String customerCode;

    /**
     * 客户名称
     */
    @ApiModelProperty("客户名称")
    @Column(name = "customer_name", length = 256, columnDefinition = "VARCHAR(256) COMMENT '客户名称'")
    private String customerName;

    /**
     * 供应商编码
     */
    @ApiModelProperty(name = "供应商编码", notes = "供应商编码")
    @Column(name = "supplier_code", length = 64, columnDefinition = "varchar(64) COMMENT '供应商编码'")
    private String supplierCode;

    /**
     * 供应商名称
     */
    @ApiModelProperty(name = "供应商名称", notes = "供应商名称")
    @Column(name = "supplier_name", columnDefinition = "varchar(255) COMMENT '供应商名称'")
    private String supplierName;

    /**
     * 年月
     */
    @ApiModelProperty(value = "年月", notes = "")
    @Column(name = "year_month_ly", length = 32, columnDefinition = "VARCHAR(32) COMMENT '年月'")
    private String yearMonthLy;

    /**
     * 服务费（元）
     */
    @ApiModelProperty("服务费（元）")
    @Column(name = "service_fee", columnDefinition = "decimal(20,6) COMMENT '服务费（元）'")
    private BigDecimal serviceFee;

    /**
     * GMV
     */
    @ApiModelProperty("GMV")
    @Column(name = "gmv", columnDefinition = "DECIMAL(20,6) COMMENT 'GMV'")
    private BigDecimal gmv;

    /**
     * 支付转化率
     */
    @ApiModelProperty("支付转化率")
    @Column(name = "payment_conversion_rate", columnDefinition = "DECIMAL(20,6) COMMENT '支付转化率'")
    private BigDecimal paymentConversionRate;

    /**
     * 推广ROI
     */
    @ApiModelProperty("推广ROI")
    @Column(name = "promote_roi", columnDefinition = "DECIMAL(20,6) COMMENT '推广ROI'")
    private BigDecimal promoteRoi;

    /**
     * 会员招募
     */
    @ApiModelProperty("会员招募")
    @Column(name = "vip", columnDefinition = "DECIMAL(20,6) COMMENT '会员招募'")
    private BigDecimal vip;

    /**
     * 折扣率
     */
    @ApiModelProperty("折扣率")
    @Column(name = "discount_rate", columnDefinition = "DECIMAL(20,6) COMMENT '折扣率'")
    private BigDecimal discountRate;

    /**
     * 不定期brief平均响应时间：<1小时
     */
    @ApiModelProperty("不定期brief平均响应时间：<1小时")
    @Column(name = "brief", columnDefinition = "DECIMAL(20,6) COMMENT '不定期brief平均响应时间：<1小时'")
    private BigDecimal brief;

    /**
     * 工作准确率
     */
    @ApiModelProperty("工作准确率")
    @Column(name = "work_accuracy", columnDefinition = "DECIMAL(20,6) COMMENT '工作准确率'")
    private BigDecimal workAccuracy;

    /**
     * 完成工作时间点
     */
    @ApiModelProperty("完成工作时间点")
    @Column(name = "completion_time_point", columnDefinition = "DECIMAL(20,6) COMMENT '完成工作时间点'")
    private BigDecimal completionTimePoint;

    /**
     * 会员成交占比（会员销售占比）
     */
    @ApiModelProperty("会员成交占比（会员销售占比）")
    @Column(name = "vip_proportion", columnDefinition = "DECIMAL(20,6) COMMENT '会员成交占比（会员销售占比）'")
    private BigDecimal vipProportion;

    /**
     * 全店60天复购率
     */
    @ApiModelProperty("全店60天复购率")
    @Column(name = "repurchase_rate", columnDefinition = "DECIMAL(20,6) COMMENT '全店60天复购率'")
    private BigDecimal repurchaseRate;

    /**
     * 新品成交占比
     */
    @ApiModelProperty("新品成交占比")
    @Column(name = "new_product", columnDefinition = "DECIMAL(20,6) COMMENT '新品成交占比'")
    private BigDecimal newProduct;

    /**
     * 新增会员数
     */
    @ApiModelProperty("新增会员数")
    @Column(name = "new_vip", columnDefinition = "DECIMAL(20,6) COMMENT '新增会员数'")
    private BigDecimal newVip;

    /**
     * 店铺折扣力度
     */
    @ApiModelProperty("店铺折扣力度")
    @Column(name = "store_discount", columnDefinition = "DECIMAL(20,6) COMMENT '店铺折扣力度'")
    private BigDecimal storeDiscount;

    /**
     * 营销活动策略&规划落地承接度
     */
    @ApiModelProperty("营销活动策略&规划落地承接度")
    @Column(name = "marketing_planning", columnDefinition = "DECIMAL(20,6) COMMENT '营销活动策略&规划落地承接度'")
    private BigDecimal marketingPlanning;

    /**
     * 市场占有率
     */
    @ApiModelProperty("市场占有率")
    @Column(name = "market_share", columnDefinition = "DECIMAL(20,6) COMMENT '市场占有率'")
    private BigDecimal marketShare;

    /**
     * 新品达成率
     */
    @ApiModelProperty("新品达成率")
    @Column(name = "new_product_achieve", columnDefinition = "DECIMAL(20,6) COMMENT '新品达成率'")
    private BigDecimal newProductAchieve;

    /**
     * 净收入达成率
     */
    @ApiModelProperty("净收入达成率")
    @Column(name = "net_income_achieve", columnDefinition = "DECIMAL(20,6) COMMENT '净收入达成率'")
    private BigDecimal netIncomeAchieve;

    /**
     * 库存周转率
     */
    @ApiModelProperty("库存周转率")
    @Column(name = "inventory_turnover_rate", columnDefinition = "DECIMAL(20,6) COMMENT '库存周转率'")
    private BigDecimal inventoryTurnoverRate;
}
