package com.biz.crm.tpm.business.agency.operation.local.register;

import com.biz.crm.tpm.business.agency.operation.sdk.dto.AgencyOperationFeeDto;
import com.biz.crm.tpm.business.agency.operation.sdk.service.AgencyOperationFeeService;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * @author: yaoyongming
 * @date: 2023/9/3 13:05
 */
@Component
public class AgencyOperationFeeFormulaVariableRegister implements FormulaVariableRegister {

    @Autowired(required = false)
    private AgencyOperationFeeService agencyOperationFeeService;

    /**
     * 变量编码
     *
     * @return 变量编码
     */
    @Override
    public String getVariableCode() {
        return "agencyOperationFee";
    }

    /**
     * 变量名称
     *
     * @return 变量名称
     */
    @Override
    public String getVariableName() {
        return "代运营费用";
    }

    /**
     * 变量排序
     *
     * @return 变量排序
     */
    @Override
    public Integer getSort() {
        return 1;
    }

    /**
     * 适用范围
     *
     * @return 适用范围
     */
    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {
        List<VariableFunctionEnum> list = Lists.newArrayList();
        list.add(VariableFunctionEnum.WITHHOLDING);
        list.add(VariableFunctionEnum.AUDIT);
        list.add(VariableFunctionEnum.WARNING);
        return list;
    }

    /**
     * 根据条件获取变量值
     *
     * @param calculateDto 计算条件
     * @return 根据条件获取变量值
     */
    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        Validate.notBlank(calculateDto.getCustomerCode(),"客户编码不能为空");
        Validate.notBlank(calculateDto.getYearMonthLy(),"年月不能为空");
        AgencyOperationFeeDto dto = new AgencyOperationFeeDto();
        dto.setCustomerCode(calculateDto.getCustomerCode());
        dto.setYearMonthLy(calculateDto.getYearMonthLy());
        BigDecimal total = agencyOperationFeeService.findForFormulaVariable(dto);

        Map<String, BigDecimal> resultMap = Maps.newHashMap();
        resultMap.put(this.getVariableCode(), Objects.nonNull(total) ? total : BigDecimal.ZERO);
        return resultMap;
    }
}
