package com.biz.crm.tpm.business.agency.operation.local.register;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * 数据视图注册器
 * 基于nebula的数据视图提供列表查询功能
 *
 * @author yaoyongming
 * @create 2023-08-16 15:20
 */
@Component
@Slf4j
public class AgencyOperationServiceWeightRegister implements DataviewRegister {

    @Override
    public String code() {
        return "agency_operation_service_weight_data_view";
    }

    @Override
    public String desc() {
        return "TPM-代运营服务费权重";
    }

    @Override
    public String buildSql() {
        return "select t.* from tpm_agency_operation_service_weight t " +
                "where t.tenant_code = :tenantCode " +
                "and t.del_flag = '" + DelFlagStatusEnum.NORMAL.getCode() + "' ";
    }

}
