package com.biz.crm.tpm.business.agency.operation.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.tpm.business.agency.operation.local.entity.AgencyOperationFee;
import com.biz.crm.tpm.business.agency.operation.local.mapper.AgencyOperationFeeMapper;
import com.biz.crm.tpm.business.agency.operation.sdk.dto.AgencyOperationFeeDto;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author: yaoyongming
 * @date: 2023/8/23 16:39
 */
@Component
public class AgencyOperationFeeRepository extends ServiceImpl<AgencyOperationFeeMapper, AgencyOperationFee> {

    /**
     * 按唯一键查询
     *
     * @param key
     * @param id
     * @return
     */
    public List<AgencyOperationFee> findByUniqueKey (String key, String id) {
        return lambdaQuery().eq(AgencyOperationFee::getUniqueKey, key)
                .ne(StringUtils.isNotBlank(id), AgencyOperationFee::getId, id)
                .list();
    }

    public BigDecimal findForFormulaVariable(AgencyOperationFeeDto dto) {
        return baseMapper.findForFormulaVariable(dto);
    }
}
